/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.Objects;

public class SignedPart {
    private final String name;
    private final String prefix;
    private final String loc;

    protected SignedPart(BuilderImpl builder) {
        this.name = builder.name();
        this.prefix = builder.prefix();
        this.loc = builder.loc();
    }

    public String name() {
        return this.name;
    }

    public String prefix() {
        return this.prefix;
    }

    public String loc() {
        return this.loc;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String name;
        protected String prefix;
        protected String loc;

        protected BuilderImpl() {
        }

        protected BuilderImpl(SignedPart model) {
            this.name = model.name();
            this.prefix = model.prefix();
            this.loc = model.loc();
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public String prefix() {
            return this.prefix;
        }

        @Override
        public Builder loc(String loc) {
            this.loc = loc;
            return this;
        }

        @Override
        public String loc() {
            return this.loc;
        }

        @Override
        public SignedPart build() {
            if (Objects.isNull(this.name())) {
                throw new IllegalArgumentException("Missing value for required field `name`");
            }
            if (Objects.isNull(this.prefix())) {
                throw new IllegalArgumentException("Missing value for required field `prefix`");
            }
            if (Objects.nonNull(this.prefix()) && this.prefix().length() < 1) {
                throw new IllegalArgumentException("The size of `prefix` must be greater than or equal to 1");
            }
            if (Objects.nonNull(this.loc()) && this.loc().length() < 1) {
                throw new IllegalArgumentException("The size of `loc` must be greater than or equal to 1");
            }
            return new SignedPart(this);
        }
    }

    public static interface Builder {
        public Builder name(String var1);

        public String name();

        public Builder prefix(String var1);

        public String prefix();

        public Builder loc(String var1);

        public String loc();

        public SignedPart build();
    }
}

