/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.List;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.LoggerListener;

final class ExecuteListeners
implements ExecuteListener {
    private static final long serialVersionUID = 7399239846062763212L;
    private static final ExecuteListener EMPTY_LISTENER = new DefaultExecuteListener();
    private static final JooqLogger LOGGER_LISTENER_LOGGER = JooqLogger.getLogger(LoggerListener.class);
    private final ExecuteListener[] listeners;
    private boolean resultStart;
    private boolean fetchEnd;

    static ExecuteListener get(ExecuteContext ctx) {
        ExecuteListener[] listeners = ExecuteListeners.listeners(ctx);
        if (listeners == null) {
            return EMPTY_LISTENER;
        }
        return new ExecuteListeners(ctx, listeners);
    }

    private static final ExecuteListener[] listeners(ExecuteContext ctx) {
        List<ExecuteListener> result = null;
        for (ExecuteListenerProvider provider : ctx.configuration().executeListenerProviders()) {
            if (provider == null) continue;
            result = ExecuteListeners.init(result);
            result.add(provider.provide());
        }
        if (!Boolean.FALSE.equals(ctx.settings().isExecuteLogging()) && LOGGER_LISTENER_LOGGER.isDebugEnabled()) {
            result = ExecuteListeners.init(result);
            result.add(new LoggerListener());
        }
        return result == null ? null : result.toArray(Tools.EMPTY_EXECUTE_LISTENER);
    }

    private static final List<ExecuteListener> init(List<ExecuteListener> result) {
        return result == null ? new ArrayList() : result;
    }

    private ExecuteListeners(ExecuteContext ctx, ExecuteListener[] listeners) {
        this.listeners = listeners;
        this.start(ctx);
    }

    @Override
    public final void start(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.start(ctx);
        }
    }

    @Override
    public final void renderStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.renderStart(ctx);
        }
    }

    @Override
    public final void renderEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.renderEnd(ctx);
        }
    }

    @Override
    public final void prepareStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.prepareStart(ctx);
        }
    }

    @Override
    public final void prepareEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.prepareEnd(ctx);
        }
    }

    @Override
    public final void bindStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.bindStart(ctx);
        }
    }

    @Override
    public final void bindEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.bindEnd(ctx);
        }
    }

    @Override
    public final void executeStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.executeStart(ctx);
        }
    }

    @Override
    public final void executeEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.executeEnd(ctx);
        }
    }

    @Override
    public final void fetchStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.fetchStart(ctx);
        }
    }

    @Override
    public final void outStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.outStart(ctx);
        }
    }

    @Override
    public final void outEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.outEnd(ctx);
        }
    }

    @Override
    public final void resultStart(ExecuteContext ctx) {
        this.resultStart = true;
        for (ExecuteListener listener : this.listeners) {
            listener.resultStart(ctx);
        }
    }

    @Override
    public final void recordStart(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.recordStart(ctx);
        }
    }

    @Override
    public final void recordEnd(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.recordEnd(ctx);
        }
    }

    @Override
    public final void resultEnd(ExecuteContext ctx) {
        this.resultStart = false;
        for (ExecuteListener listener : this.listeners) {
            listener.resultEnd(ctx);
        }
        if (this.fetchEnd) {
            this.fetchEnd(ctx);
        }
    }

    @Override
    public final void fetchEnd(ExecuteContext ctx) {
        if (this.resultStart) {
            this.fetchEnd = true;
        } else {
            for (ExecuteListener listener : this.listeners) {
                listener.fetchEnd(ctx);
            }
        }
    }

    @Override
    public final void end(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.end(ctx);
        }
    }

    @Override
    public final void exception(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.exception(ctx);
        }
    }

    @Override
    public final void warning(ExecuteContext ctx) {
        for (ExecuteListener listener : this.listeners) {
            listener.warning(ctx);
        }
    }
}

