# Contributing to OpenTofu

Welcome and thank you for wanting to contribute!

## Get started

- Have a question? Post it in [GitHub Discussions ➡️](https://github.com/orgs/opentofu/discussions) or on the [OpenTofu Slack ➡️](https://opentofu.org/slack/)!
- Found a bug? [Report it here ➡️](https://github.com/opentofu/opentofu/issues/new?assignees=&labels=bug%2Cpending-decision&projects=&template=bug_report.yml)
- Have a feature idea? [Submit it here ➡️](https://github.com/opentofu/opentofu/issues/new?assignees=&labels=enhancement%2Cpending-decision&projects=&template=feature_request.yml)
- Want to help define a complex feature or bug fix? [Write an RFC here ➡️](./rfc/README.md)
- Want to add a feature, fix bug, refactor something, or add CI tooling?
  1. Check if there is an [open issue with the `accepted` and `help wanted` labels](https://github.com/opentofu/opentofu/issues?q=is%3Aopen+is%3Aissue+label%3Aaccepted+label%3A"help+wanted"),
  2. Comment on the issue that you want to work on it,
  3. Wait for a maintainer to assign it to you,
  4. Then [submit your code here ➡️](https://github.com/opentofu/opentofu/compare)
- Recurring Events
  - [Community Meetings](https://meet.google.com/xfm-cgms-has) on Wednesdays at 12:30 UTC at this link: https://meet.google.com/xfm-cgms-has ([📅 calendar link](https://calendar.google.com/calendar/event?eid=NDg0aWl2Y3U1aHFva3N0bGhyMHBhNzdpZmsgY18zZjJkZDNjMWZlMGVmNGU5M2VmM2ZjNDU2Y2EyZGQyMTlhMmU4ZmQ4NWY2YjQwNzUwYWYxNmMzZGYzNzBiZjkzQGc))
  - [Technical Steering Committee Meetings](https://meet.google.com/cry-houa-qbk) every other Tuesday at 4pm UTC at this link: https://meet.google.com/cry-houa-qbk ([📅 calendar link](https://calendar.google.com/calendar/u/0/event?eid=M3JyMWtuYWptdXI0Zms4ZnJpNmppcDczb3RfMjAyNTA1MjdUMTYwMDAwWiBjXzNmMmRkM2MxZmUwZWY0ZTkzZWYzZmM0NTZjYTJkZDIxOWEyZThmZDg1ZjZiNDA3NTBhZjE2YzNkZjM3MGJmOTNAZw))

> [!TIP]
> For more OpenTofu events, subscribe to the [OpenTofu Events Calendar](https://calendar.google.com/calendar/embed?src=c_3f2dd3c1fe0ef4e93ef3fc456ca2dd219a2e8fd85f6b40750af16c3df370bf93%40group.calendar.google.com)!

**⚠️ Important:** Please avoid working on features or refactor without [an `accepted` and `help-wanted` issue](https://github.com/opentofu/opentofu/issues?q=is%3Aopen+is%3Aissue+label%3Aaccepted+label%3A"help+wanted"). OpenTofu is a large and complex project and every change needs careful consideration. We cannot merge pull requests without first having a discussion about them, no matter how trivial the issue may seem.

Check out our [Contributing FAQ](contributing/FAQ.md) and [Development Guide](contributing/DEVELOPING.md) for more detailed information.

# Getting Involved

OpenTofu has a variety of roles that need dedicated and skilled people to fill. How we operate is defined in our [Charter](https://github.com/opentofu/org/blob/main/CHARTER.md) and implemented by the TSC in our [Governance](https://github.com/opentofu/org/blob/main/GOVERNANCE.md).

## Contributors

Anyone can contribute to OpenTofu by submitting an issue, helping track down a bug, opening a PR, or help in any way to advance the OpenTofu project.

## Maintainers

Maintainers are anyone who is a "Committer" (as defined in the Charter) to one or more repositories.

The list of current maintainers and their responsibilities can be found in [MAINTAINERS.md](MAINTAINERS.md).

## TSC Members

The current TSC members are:
- Arel Rabinowitz ([@RLRabinowitz](https://github.com/RLRabinowitz)) - env0
- Christian Mesh ([@cam72cam](https://github.com/cam72cam)) - Spacelift
- Igor Savchenko ([@DiscyDel](https://github.com/DicsyDel)) - Scalr Inc.
- James Humphries ([@Yantrio](https://github.com/Yantrio)) - Spacelift
- Roger Simms ([@allofthesepeople](https://github.com/allofthesepeople)) - Harness Inc.
- Yousif Akbar ([@yhakbar](https://github.com/yhakbar)) - Gruntwork, Inc.

Agendas and meeting notes can be found in the [opentofu/org/TSC](https://github.com/opentofu/org/tree/main/TSC) folder. Anyone may open a PR to add a new
agenda item for the next TSC meeting.  More information on the TSC structure can be found in our [Governance](https://github.com/opentofu/org/blob/main/GOVERNANCE.md)
