/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.legacy;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Parser;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.creole.atom.AtomHorizontalTexts;
import net.sourceforge.plantuml.klimt.creole.atom.AtomImg;
import net.sourceforge.plantuml.klimt.creole.atom.AtomOpenIcon;
import net.sourceforge.plantuml.klimt.creole.atom.AtomSprite;
import net.sourceforge.plantuml.klimt.creole.atom.AtomVerticalTexts;
import net.sourceforge.plantuml.klimt.creole.legacy.AtomText;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.ImgValign;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.openiconic.OpenIcon;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.url.Url;

public class AtomTextUtils {
    protected static AtomText.DelayedDouble ZERO = new AtomText.DelayedDouble(){

        @Override
        public double getDouble(StringBounder stringBounder) {
            return 0.0;
        }
    };
    private static final Pattern p = Pattern.compile("\\<(#\\w+)?&([-\\w]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,?color[= :](?:#[0-9a-fA-F]{1,8}|\\w+))?\\}?)?\\>|\\<(#\\w+)?\\$([-\\p{L}0-9_/]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,?color[= :](?:#[0-9a-fA-F]{1,8}|\\w+))?\\}?)?\\>|\\<img[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>|\\<(#\\w+)?:([0-9a-z][0-9_a-z]*):([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,?color[= :](?:#[0-9a-fA-F]{1,8}|\\w+))?\\}?)?\\>");

    public static Atom createLegacy(String text, FontConfiguration fontConfiguration) {
        return new AtomText(text, fontConfiguration, null, ZERO, ZERO, true);
    }

    public static Atom create(String text, FontConfiguration fontConfiguration) {
        return new AtomText(text, fontConfiguration, null, ZERO, ZERO, false);
    }

    public static Atom createUrl(Url url, FontConfiguration fontConfiguration, ISkinSimple skinSimple) {
        fontConfiguration = fontConfiguration.hyperlink();
        Display display = Display.getWithNewlines(skinSimple.getPragma(), url.getLabel());
        if (display.size() > 1) {
            ArrayList<Atom> all = new ArrayList<Atom>();
            for (CharSequence charSequence : display.asList()) {
                all.add(AtomTextUtils.createAtomTextForUrl(charSequence.toString(), url, fontConfiguration, skinSimple));
            }
            return new AtomVerticalTexts(all);
        }
        return AtomTextUtils.createAtomTextForUrl(url.getLabel(), url, fontConfiguration, skinSimple);
    }

    private static Atom createAtomTextForUrl(String text, Url url, FontConfiguration fontConfiguration, ISkinSimple skinSimple) {
        StringBuffer sb;
        Matcher m = p.matcher(text);
        ArrayList<Atom> result = new ArrayList<Atom>();
        while (m.find()) {
            double scale;
            sb = new StringBuffer();
            m.appendReplacement(sb, "");
            if (sb.length() > 0) {
                result.add(new AtomText(sb.toString(), fontConfiguration, url, ZERO, ZERO, true));
            }
            String valOpenicon = m.group(2);
            String valSprite = m.group(5);
            String valImg = m.group(7);
            String valEmoji = m.group(9);
            if (valEmoji != null) {
                throw new UnsupportedOperationException();
            }
            if (valOpenicon != null) {
                OpenIcon openIcon = OpenIcon.retrieve(valOpenicon);
                if (openIcon == null) continue;
                scale = Parser.getScale(m.group(3), 1.0);
                result.add(new AtomOpenIcon(null, scale, openIcon, fontConfiguration, url));
                continue;
            }
            if (valSprite != null) {
                Sprite sprite = skinSimple.getSprite(valSprite);
                if (sprite == null) continue;
                scale = Parser.getScale(m.group(6), 1.0);
                HColor fontColor = fontConfiguration.getColor();
                HColor forcedColor = null;
                result.add(new AtomSprite(fontColor, forcedColor, scale, sprite, url, null));
                continue;
            }
            if (valImg == null) continue;
            double scale2 = Parser.getScale(m.group(8), 1.0);
            result.add(AtomImg.create(valImg, ImgValign.TOP, 0, scale2, url));
        }
        sb = new StringBuffer();
        m.appendTail(sb);
        if (sb.length() > 0) {
            result.add(new AtomText(sb.toString(), fontConfiguration, url, ZERO, ZERO, true));
        }
        if (result.size() == 1) {
            return (Atom)result.get(0);
        }
        return new AtomHorizontalTexts(result);
    }

    public static Atom createListNumber(final FontConfiguration fontConfiguration, final int order, int localNumber) {
        AtomText.DelayedDouble left = new AtomText.DelayedDouble(){

            @Override
            public double getDouble(StringBounder stringBounder) {
                XDimension2D dim = stringBounder.calculateDimension(fontConfiguration.getFont(), "9. ");
                return dim.getWidth() * (double)order;
            }
        };
        AtomText.DelayedDouble right = new AtomText.DelayedDouble(){

            @Override
            public double getDouble(StringBounder stringBounder) {
                XDimension2D dim = stringBounder.calculateDimension(fontConfiguration.getFont(), ".");
                return dim.getWidth();
            }
        };
        return new AtomText("" + (localNumber + 1) + ".", fontConfiguration, null, left, right, true);
    }
}

