/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.project.draw.PathUtils;
import net.sourceforge.plantuml.sequencediagram.graphic.Segment;

public class RectangleTask {
    private final List<Segment> segments;
    private final double round;
    private final int completion;

    public RectangleTask(double startPos, double endPos, double round, int completion, Collection<Segment> paused) {
        this.round = round;
        this.completion = completion;
        this.segments = startPos < endPos ? new ArrayList<Segment>(new Segment(startPos, endPos).cutSegmentIfNeed(paused)) : Collections.singletonList(new Segment(startPos, startPos + 1.0));
    }

    private void draw2hlines(UGraphic ug, double height, ULine hline) {
        ug.draw(hline);
        ug.apply(UTranslate.dy(height)).draw(hline);
    }

    public void draw(UGraphic ug, double height, HColor documentBackground, boolean oddStart, boolean oddEnd) {
        if (this.round == 0.0) {
            this.drawWithoutRound(ug, height, documentBackground, oddStart, oddEnd);
            return;
        }
        if (this.segments.size() != 1) {
            this.drawWithRound(ug, height, documentBackground);
            return;
        }
        assert (this.segments.size() == 1);
        assert (this.round > 0.0);
        Segment segment = this.segments.get(0);
        double width = segment.getLength();
        URectangle partial = URectangle.build(width, height).rounded(this.round);
        if (this.completion == 100 || this.completion == 0) {
            if (this.completion == 0) {
                ug = ug.apply(documentBackground.bg());
            }
            if (oddStart && !oddEnd) {
                ug.apply(UTranslate.dx(segment.getPos1())).draw(PathUtils.UtoRight(width, height, this.round));
            } else if (!oddStart && oddEnd) {
                ug.apply(UTranslate.dx(segment.getPos1())).draw(PathUtils.UtoLeft(width, height, this.round));
            } else {
                ug.apply(UTranslate.dx(segment.getPos1())).draw(partial);
            }
        } else {
            double x1 = width * (double)this.completion / 100.0;
            ug.apply(HColors.none()).apply(UTranslate.dx(segment.getPos1())).draw(PathUtils.UtoLeft(x1, height, this.round));
            ug.apply(documentBackground.bg()).apply(HColors.none()).apply(UTranslate.dx(segment.getPos1() + x1)).draw(PathUtils.UtoRight(width * (double)(100 - this.completion) / 100.0, height, this.round));
            ug.apply(HColors.none().bg()).apply(UTranslate.dx(segment.getPos1())).draw(partial);
        }
    }

    private void drawWithRound(UGraphic ug, double height, HColor documentBackground) {
        Segment first = this.segments.get(0);
        ug.apply(UTranslate.dx(first.getPos1())).draw(PathUtils.UtoLeft(first.getLength(), height, this.round));
        for (int i = 1; i < this.segments.size() - 1; ++i) {
            Segment segment = this.segments.get(i);
            this.drawPartly(segment.getLength() * (double)this.completion / 100.0, ug, segment, height, documentBackground, i, false, false);
        }
        Segment last = this.segments.get(this.segments.size() - 1);
        ug.apply(UTranslate.dx(last.getPos1())).draw(PathUtils.UtoRight(last.getLength(), height, this.round));
        this.drawIntermediateDotted(ug, height);
    }

    private void drawWithoutRound(UGraphic ug, double height, HColor documentBackground, boolean oddStart, boolean oddEnd) {
        double lim;
        double sumWidth = this.getFullSegmentsLength();
        double d = lim = this.completion == 100 ? sumWidth : sumWidth * (double)this.completion / 100.0;
        if (this.segments.size() == 1 && !oddStart && !oddEnd) {
            this.drawFull(this.completion == 100 ? -1.0 : lim, ug, this.segments.get(0), height, documentBackground);
            return;
        }
        double current = 0.0;
        for (int i = 0; i < this.segments.size(); ++i) {
            double widthCompletion;
            Segment segment = this.segments.get(i);
            double next = current + segment.getLength();
            if (lim >= next) {
                widthCompletion = -1.0;
            } else if (current >= lim) {
                widthCompletion = 0.0;
            } else {
                assert (current < lim && lim < next);
                widthCompletion = lim - current;
            }
            this.drawPartly(widthCompletion, ug, segment, height, documentBackground, i, !oddStart && i == 0, !oddEnd && i == this.segments.size() - 1);
            current = next;
        }
        this.drawIntermediateDotted(ug, height);
    }

    private double getFullSegmentsLength() {
        double result = 0.0;
        for (Segment seg : this.segments) {
            result += seg.getLength();
        }
        return result;
    }

    private void drawIntermediateDotted(UGraphic ug, double height) {
        ug = ug.apply(new UStroke(2.0, 3.0, 1.0));
        for (int i = 0; i < this.segments.size() - 1; ++i) {
            double v1 = this.segments.get(i).getPos2() + 3.0;
            double v2 = this.segments.get(i + 1).getPos1() - 3.0;
            if (!(v2 > v1)) continue;
            this.draw2hlines(ug.apply(UTranslate.dx(v1)), height, ULine.hline(v2 - v1));
        }
    }

    private void drawFull(double widthCompletion, UGraphic ug, Segment segment, double height, HColor documentBackground) {
        double width = segment.getLength();
        ug = ug.apply(UTranslate.dx(segment.getPos1()));
        this.drawBackgroundRect(widthCompletion, ug.apply(HColors.none()), documentBackground, width, height);
        URectangle rect = URectangle.build(width, height);
        ug.apply(HColors.none().bg()).draw(rect);
    }

    private void drawPartly(double widthCompletion, UGraphic ug, Segment segment, double height, HColor documentBackground, int i, boolean withStartVline, boolean withEndVline) {
        if (withStartVline && withEndVline) {
            throw new IllegalArgumentException();
        }
        double widthBack = segment.getLength();
        if (i != this.segments.size() - 1) {
            widthBack += 1.0;
        }
        ug = ug.apply(UTranslate.dx(segment.getPos1()));
        if (widthBack > 0.0) {
            this.drawBackgroundRect(widthCompletion, ug.apply(HColors.none()), documentBackground, widthBack, height);
        }
        ug = ug.apply(HColors.none().bg());
        if (withStartVline) {
            ug.draw(PathUtils.UtoLeft(segment.getLength(), height, 0.0));
        } else if (withEndVline) {
            ug.apply(UTranslate.dx(segment.getLength() - segment.getLength())).draw(PathUtils.UtoRight(segment.getLength(), height, 0.0));
        } else {
            this.draw2hlines(ug, height, ULine.hline(segment.getLength()));
        }
    }

    private void drawBackgroundRect(double widthCompletion, UGraphic ug, HColor documentBackground, double width, double height) {
        if (widthCompletion == -1.0 || widthCompletion == 0.0) {
            if (widthCompletion == 0.0) {
                ug = ug.apply(documentBackground.bg());
            }
            URectangle rect = URectangle.build(width, height);
            ug.draw(rect);
        } else {
            URectangle rect1 = URectangle.build(widthCompletion, height);
            ug.draw(rect1);
            URectangle rect2 = URectangle.build(width - widthCompletion, height);
            ug.apply(documentBackground.bg()).apply(UTranslate.dx(widthCompletion)).draw(rect2);
        }
    }
}

