\name{LabelOverlapMeasuresImageFilter}
\alias{LabelOverlapMeasuresImageFilter}
\title{LabelOverlapMeasuresImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes overlap measures between the set same set of labels of pixels
of two images. Background is assumed to be 0.
LabelOverlapMeasuresImageFilter}
\details{
This code was contributed in the Insight Journal paper: "Introducing
Dice, Jaccard, and Other Label Overlap Measures To ITK" by Nicholas
J. Tustison, James C. Gee https://www.insight-journal.org/browse/publication/707
Nicholas J. Tustison
See:
LabelOverlapMeasuresImageFilter
itk::LabelOverlapMeasuresImageFilter for the Doxygen on the original ITK class.
LabelOverlapMeasuresImageFilter}
%C++ includes: sitkLabelOverlapMeasuresImageFilter.h
\section{Methods}{
\describe{
\item{void Execute(const Image &sourceImage, const Image &targetImage):}{
Execute the filter on the input image
}
\item{double GetDiceCoefficient() const:}{
Get the mean overlap (Dice coefficient) for the specified individual
label.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetDiceCoefficient(int64_t label) const:}{
Get the mean overlap (Dice coefficient) for the specified individual
label.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetFalseDiscoveryRate() const:}{
Get the false discovery rate for the specified individual label.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetFalseDiscoveryRate(int64_t label) const:}{
Get the false discovery rate for the specified individual label.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetFalseNegativeError() const:}{
Get the false negative error for the specified individual label.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetFalseNegativeError(int64_t label) const:}{
Get the false negative error for the specified individual label.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetFalsePositiveError() const:}{
Get the false positive error for the specified individual label.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetFalsePositiveError(int64_t label) const:}{
Get the false positive error for the specified individual label.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetJaccardCoefficient() const:}{
Get the union overlap (Jaccard coefficient) for the specified
individual label.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetJaccardCoefficient(int64_t label) const:}{
Get the union overlap (Jaccard coefficient) for the specified
individual label.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetMeanOverlap() const:}{
Get the mean overlap (Dice coefficient) for the specified individual
label.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetMeanOverlap(int64_t label) const:}{
Get the mean overlap (Dice coefficient) for the specified individual
label.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetUnionOverlap() const:}{
Get the union overlap (Jaccard coefficient) for the specified
individual label.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetUnionOverlap(int64_t label) const:}{
Get the union overlap (Jaccard coefficient) for the specified
individual label.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{double GetVolumeSimilarity() const:}{
Get the volume similarity for the specified individual label.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetVolumeSimilarity(int64_t label) const:}{
Get the volume similarity for the specified individual label.
This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.
}
\item{ LabelOverlapMeasuresImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~LabelOverlapMeasuresImageFilter():}{
Destructor
}
}
}
