\name{OpeningByReconstructionImageFilter}
\alias{OpeningByReconstructionImageFilter}
\title{OpeningByReconstructionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Opening by reconstruction of an image.
OpeningByReconstructionImageFilter}
\details{
This filter preserves regions, in the foreground, that can completely
contain the structuring element. At the same time, this filter
eliminates all other regions of foreground pixels. Contrary to the
morphological opening, the opening by reconstruction preserves the
shape of the components that are not removed by erosion. The opening
by reconstruction of an image "f" is defined as:
OpeningByReconstruction(f) = DilationByReconstruction(f, Erosion(f)).
Opening by reconstruction not only removes structures destroyed by the
erosion, but also levels down the contrast of the brightest regions.
If PreserveIntensities is on, a subsequent reconstruction by dilation
using a marker image that is the original image for all unaffected
pixels.
Opening by reconstruction is described in Chapter 6.3.9 of Pierre
Soille's book "Morphological Image Analysis: Principles and
Applications", Second Edition, Springer, 2003.
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
GrayscaleMorphologicalOpeningImageFilter
OpeningByReconstruction for the procedural interface
itk::OpeningByReconstructionImageFilter for the Doxygen on the original ITK class.
OpeningByReconstructionImageFilter}
%C++ includes: sitkOpeningByReconstructionImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::vector< unsigned int > GetKernelRadius() const:}{
Get the radius of the kernel structuring element.
}
\item{KernelEnum GetKernelType() const:}{
Get the kernel or structuring element used for the morphology.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetPreserveIntensities() const:}{
Set/Get whether the original intensities of the image retained for
those pixels unaffected by the opening by reconstruction. If Off, the
output pixel contrast will be reduced.
}
\item{ OpeningByReconstructionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self PreserveIntensitiesOff():}{}
\item{Self PreserveIntensitiesOn():}{
Set the value of PreserveIntensities to true or false respectfully.
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{Self SetKernelRadius(std::vector< unsigned int > KernelRadius):}{
Set the radius of the kernel structuring element.
}
\item{Self SetKernelRadius(unsigned int value):}{
Set the values of the KernelRadius vector all to value
}
\item{Self SetKernelType(KernelEnum KernelType):}{
Set the kernel or structuring element used for the morphology.
}
\item{Self SetPreserveIntensities(bool PreserveIntensities):}{
Set/Get whether the original intensities of the image retained for
those pixels unaffected by the opening by reconstruction. If Off, the
output pixel contrast will be reduced.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~OpeningByReconstructionImageFilter():}{
Destructor
}
}
}
