/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.NetworkChannel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;
import org.apache.tomcat.util.net.openssl.ciphers.Group;
import org.apache.tomcat.util.net.openssl.ciphers.SignatureScheme;

public abstract class AbstractJsseEndpoint<S, U>
extends AbstractEndpoint<S, U> {
    static final ThreadLocal<List<String>> clientRequestedProtocolsThreadLocal = new ThreadLocal();
    static final ThreadLocal<List<Group>> clientSupportedGroupsThreadLocal = new ThreadLocal();
    static final ThreadLocal<List<SignatureScheme>> clientSignatureSchemesThreadLocal = new ThreadLocal();
    private String sslImplementationName = null;
    private int sniParseLimit = 65536;
    private SSLImplementation sslImplementation = null;

    public String getSslImplementationName() {
        return this.sslImplementationName;
    }

    public void setSslImplementationName(String string) {
        this.sslImplementationName = string;
    }

    public SSLImplementation getSslImplementation() {
        return this.sslImplementation;
    }

    public int getSniParseLimit() {
        return this.sniParseLimit;
    }

    public void setSniParseLimit(int n) {
        this.sniParseLimit = n;
    }

    protected void initialiseSsl() throws Exception {
        if (this.isSSLEnabled()) {
            this.sslImplementation = SSLImplementation.getInstance(this.getSslImplementationName());
            for (SSLHostConfig sSLHostConfig : this.sslHostConfigs.values()) {
                this.createSSLContext(sSLHostConfig);
            }
            if (this.sslHostConfigs.get(this.getDefaultSSLHostConfigName()) == null) {
                throw new IllegalArgumentException(sm.getString("endpoint.noSslHostConfig", new Object[]{this.getDefaultSSLHostConfigName(), this.getName()}));
            }
        }
    }

    @Override
    protected void createSSLContext(SSLHostConfig sSLHostConfig) throws IllegalArgumentException {
        boolean bl = true;
        for (SSLHostConfigCertificate sSLHostConfigCertificate : sSLHostConfig.getCertificates(true)) {
            SSLUtil sSLUtil = this.sslImplementation.getSSLUtil(sSLHostConfigCertificate);
            if (bl) {
                bl = false;
                sSLHostConfig.setEnabledProtocols(sSLUtil.getEnabledProtocols());
                sSLHostConfig.setEnabledCiphers(sSLUtil.getEnabledCiphers());
            }
            SSLContext sSLContext = sSLHostConfigCertificate.getSslContext();
            SSLContext sSLContext2 = sSLHostConfigCertificate.getSslContextGenerated();
            if (sSLContext == null || sSLContext == sSLContext2) {
                try {
                    sSLContext = sSLUtil.createSSLContext(this.negotiableProtocols);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(sm.getString("endpoint.errorCreatingSSLContext"), exception);
                }
                sSLHostConfigCertificate.setSslContextGenerated(sSLContext);
            }
            this.logCertificate(sSLHostConfigCertificate);
        }
    }

    protected SSLEngine createSSLEngine(String string, List<Cipher> list, List<String> list2) {
        String[] stringArray;
        ArrayList<String> arrayList;
        SSLHostConfig sSLHostConfig;
        SSLHostConfigCertificate sSLHostConfigCertificate;
        SSLContext sSLContext;
        List<SignatureScheme> list3;
        List<Group> list4;
        List<String> list5 = clientRequestedProtocolsThreadLocal.get();
        if (list5 == null) {
            list5 = new ArrayList<String>();
        }
        if ((list4 = clientSupportedGroupsThreadLocal.get()) == null) {
            list4 = new ArrayList<Group>();
        }
        if ((list3 = clientSignatureSchemesThreadLocal.get()) == null) {
            list3 = new ArrayList<SignatureScheme>();
        }
        if ((sSLContext = (sSLHostConfigCertificate = this.selectCertificate(sSLHostConfig = this.getSSLHostConfig(string), list, list5, list3)).getSslContext()) == null) {
            throw new IllegalStateException(sm.getString("endpoint.jsse.noSslContext", new Object[]{string}));
        }
        SSLEngine sSLEngine = sSLContext.createSSLEngine();
        sSLEngine.setUseClientMode(false);
        sSLEngine.setEnabledCipherSuites(sSLHostConfig.getEnabledCiphers());
        sSLEngine.setEnabledProtocols(sSLHostConfig.getEnabledProtocols());
        SSLParameters sSLParameters = sSLEngine.getSSLParameters();
        sSLParameters.setUseCipherSuitesOrder(sSLHostConfig.getHonorCipherOrder());
        if (JreCompat.isAlpnSupported() && list2 != null && list2.size() > 0 && this.negotiableProtocols.size() > 0) {
            arrayList = new ArrayList(this.negotiableProtocols);
            arrayList.retainAll(list2);
            if (arrayList.size() > 0) {
                stringArray = arrayList.toArray(new String[0]);
                JreCompat.getInstance().setApplicationProtocols(sSLParameters, stringArray);
            }
        }
        if (JreCompat.isJre20Available()) {
            arrayList = new ArrayList<String>();
            stringArray = sSLHostConfig.getGroupList();
            if (stringArray != null) {
                if (!list4.isEmpty()) {
                    for (Group group : list4) {
                        if (!stringArray.contains((Object)group)) continue;
                        arrayList.add(group.toString());
                    }
                } else {
                    for (Group group : stringArray) {
                        arrayList.add(group.toString());
                    }
                }
                JreCompat.getInstance().setNamedGroupsMethod((Object)sSLParameters, arrayList.toArray(new String[0]));
            } else if (!list4.isEmpty()) {
                for (Group group : list4) {
                    arrayList.add(group.toString());
                }
                JreCompat.getInstance().setNamedGroupsMethod((Object)sSLParameters, arrayList.toArray(new String[0]));
            }
        }
        switch (sSLHostConfig.getCertificateVerification()) {
            case NONE: {
                sSLParameters.setNeedClientAuth(false);
                sSLParameters.setWantClientAuth(false);
                break;
            }
            case OPTIONAL: 
            case OPTIONAL_NO_CA: {
                sSLParameters.setWantClientAuth(true);
                break;
            }
            case REQUIRED: {
                sSLParameters.setNeedClientAuth(true);
            }
        }
        sSLEngine.setSSLParameters(sSLParameters);
        return sSLEngine;
    }

    private SSLHostConfigCertificate selectCertificate(SSLHostConfig sSLHostConfig, List<Cipher> list, List<String> list2, List<SignatureScheme> list3) {
        Set<SSLHostConfigCertificate> set = sSLHostConfig.getCertificates(true);
        if (set.size() == 1) {
            return set.iterator().next();
        }
        if (list2.contains("TLSv1.3") && sSLHostConfig.getProtocols().contains("TLSv1.3")) {
            for (SignatureScheme object2 : list3) {
                for (SSLHostConfigCertificate sSLHostConfigCertificate : set) {
                    if (!sSLHostConfigCertificate.getType().isCompatibleWith(object2)) continue;
                    return sSLHostConfigCertificate;
                }
            }
        }
        LinkedHashSet<Cipher> linkedHashSet = sSLHostConfig.getCipherList();
        ArrayList<Cipher> arrayList = new ArrayList<Cipher>();
        if (sSLHostConfig.getHonorCipherOrder()) {
            arrayList.addAll(linkedHashSet);
            arrayList.retainAll(list);
        } else {
            arrayList.addAll(list);
            arrayList.retainAll(linkedHashSet);
        }
        for (Cipher cipher : arrayList) {
            for (SSLHostConfigCertificate sSLHostConfigCertificate : set) {
                if (!sSLHostConfigCertificate.getType().isCompatibleWith(cipher.getAu())) continue;
                return sSLHostConfigCertificate;
            }
        }
        return set.iterator().next();
    }

    @Override
    public boolean isAlpnSupported() {
        SSLImplementation sSLImplementation;
        if (!this.isSSLEnabled()) {
            return false;
        }
        try {
            sSLImplementation = SSLImplementation.getInstance(this.getSslImplementationName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return sSLImplementation.isAlpnSupported();
    }

    @Override
    public void unbind() throws Exception {
        for (SSLHostConfig sSLHostConfig : this.sslHostConfigs.values()) {
            for (SSLHostConfigCertificate sSLHostConfigCertificate : sSLHostConfig.getCertificates(true)) {
                sSLHostConfigCertificate.setSslContextGenerated(null);
            }
        }
    }

    protected abstract NetworkChannel getServerSocket();

    @Override
    protected final InetSocketAddress getLocalAddress() throws IOException {
        NetworkChannel networkChannel = this.getServerSocket();
        if (networkChannel == null) {
            return null;
        }
        SocketAddress socketAddress = networkChannel.getLocalAddress();
        if (socketAddress instanceof InetSocketAddress) {
            return (InetSocketAddress)socketAddress;
        }
        return null;
    }

    @Override
    protected void setDefaultSslHostConfig(SSLHostConfig sSLHostConfig) {
    }
}

