/* Copyright (C) 2020 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// This file is generated by generate-gpup-webgl. Do not edit.

#include "config.h"
#include "RemoteGraphicsContextGL.h"

#include "Logging.h"
#include <wtf/StdLibExtras.h>

#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)

#define MESSAGE_CHECK(assertion) MESSAGE_CHECK_BASE(assertion, m_connection);

namespace WebKit {
using namespace WebCore;

void RemoteGraphicsContextGL::activeTexture(uint32_t texture)
{
    assertIsCurrent(workQueue());
    protectedContext()->activeTexture(texture);
}

void RemoteGraphicsContextGL::attachShader(uint32_t program, uint32_t shader)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(program));
    if (program)
        program = m_objectNames.get(program);
    MESSAGE_CHECK(m_objectNames.isValidKey(shader));
    if (shader)
        shader = m_objectNames.get(shader);
    protectedContext()->attachShader(program, shader);
}

void RemoteGraphicsContextGL::bindAttribLocation(uint32_t arg0, uint32_t index, CString&& name)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    protectedContext()->bindAttribLocation(arg0, index, name);
}

void RemoteGraphicsContextGL::bindBuffer(uint32_t target, uint32_t arg1)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg1));
    if (arg1)
        arg1 = m_objectNames.get(arg1);
    protectedContext()->bindBuffer(target, arg1);
}

void RemoteGraphicsContextGL::bindFramebuffer(uint32_t target, uint32_t arg1)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg1));
    if (arg1)
        arg1 = m_objectNames.get(arg1);
    protectedContext()->bindFramebuffer(target, arg1);
}

void RemoteGraphicsContextGL::bindRenderbuffer(uint32_t target, uint32_t arg1)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg1));
    if (arg1)
        arg1 = m_objectNames.get(arg1);
    protectedContext()->bindRenderbuffer(target, arg1);
}

void RemoteGraphicsContextGL::bindTexture(uint32_t target, uint32_t arg1)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg1));
    if (arg1)
        arg1 = m_objectNames.get(arg1);
    protectedContext()->bindTexture(target, arg1);
}

void RemoteGraphicsContextGL::blendColor(float red, float green, float blue, float alpha)
{
    assertIsCurrent(workQueue());
    protectedContext()->blendColor(red, green, blue, alpha);
}

void RemoteGraphicsContextGL::blendEquation(uint32_t mode)
{
    assertIsCurrent(workQueue());
    protectedContext()->blendEquation(mode);
}

void RemoteGraphicsContextGL::blendEquationSeparate(uint32_t modeRGB, uint32_t modeAlpha)
{
    assertIsCurrent(workQueue());
    protectedContext()->blendEquationSeparate(modeRGB, modeAlpha);
}

void RemoteGraphicsContextGL::blendFunc(uint32_t sfactor, uint32_t dfactor)
{
    assertIsCurrent(workQueue());
    protectedContext()->blendFunc(sfactor, dfactor);
}

void RemoteGraphicsContextGL::blendFuncSeparate(uint32_t srcRGB, uint32_t dstRGB, uint32_t srcAlpha, uint32_t dstAlpha)
{
    assertIsCurrent(workQueue());
    protectedContext()->blendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
}

void RemoteGraphicsContextGL::checkFramebufferStatus(uint32_t target, CompletionHandler<void(uint32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLenum returnValue = { };
    returnValue = protectedContext()->checkFramebufferStatus(target);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::clear(uint32_t mask)
{
    assertIsCurrent(workQueue());
    protectedContext()->clear(mask);
}

void RemoteGraphicsContextGL::clearColor(float red, float green, float blue, float alpha)
{
    assertIsCurrent(workQueue());
    protectedContext()->clearColor(red, green, blue, alpha);
}

void RemoteGraphicsContextGL::clearDepth(float depth)
{
    assertIsCurrent(workQueue());
    protectedContext()->clearDepth(depth);
}

void RemoteGraphicsContextGL::clearStencil(int32_t s)
{
    assertIsCurrent(workQueue());
    protectedContext()->clearStencil(s);
}

void RemoteGraphicsContextGL::colorMask(bool red, bool green, bool blue, bool alpha)
{
    assertIsCurrent(workQueue());
    protectedContext()->colorMask(static_cast<GCGLboolean>(red), static_cast<GCGLboolean>(green), static_cast<GCGLboolean>(blue), static_cast<GCGLboolean>(alpha));
}

void RemoteGraphicsContextGL::compileShader(uint32_t arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    protectedContext()->compileShader(arg0);
}

void RemoteGraphicsContextGL::copyTexImage2D(uint32_t target, int32_t level, uint32_t internalformat, int32_t x, int32_t y, int32_t width, int32_t height, int32_t border)
{
    assertIsCurrent(workQueue());
    protectedContext()->copyTexImage2D(target, level, internalformat, x, y, width, height, border);
}

void RemoteGraphicsContextGL::copyTexSubImage2D(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t x, int32_t y, int32_t width, int32_t height)
{
    assertIsCurrent(workQueue());
    protectedContext()->copyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
}

void RemoteGraphicsContextGL::createBuffer(uint32_t name)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(name));
    auto result = protectedContext()->createBuffer();
    if (result)
        m_objectNames.add(name, result);
}

void RemoteGraphicsContextGL::createFramebuffer(uint32_t name)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(name));
    auto result = protectedContext()->createFramebuffer();
    if (result)
        m_objectNames.add(name, result);
}

void RemoteGraphicsContextGL::createProgram(uint32_t name)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(name));
    auto result = protectedContext()->createProgram();
    if (result)
        m_objectNames.add(name, result);
}

void RemoteGraphicsContextGL::createRenderbuffer(uint32_t name)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(name));
    auto result = protectedContext()->createRenderbuffer();
    if (result)
        m_objectNames.add(name, result);
}

void RemoteGraphicsContextGL::createShader(uint32_t name, uint32_t arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(name));
    auto result = protectedContext()->createShader(arg0);
    if (result)
        m_objectNames.add(name, result);
}

void RemoteGraphicsContextGL::createTexture(uint32_t name)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(name));
    auto result = protectedContext()->createTexture();
    if (result)
        m_objectNames.add(name, result);
}

void RemoteGraphicsContextGL::cullFace(uint32_t mode)
{
    assertIsCurrent(workQueue());
    protectedContext()->cullFace(mode);
}

void RemoteGraphicsContextGL::deleteBuffer(uint32_t arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (!arg0) [[unlikely]]
        return;
    arg0 = m_objectNames.take(arg0);
    protectedContext()->deleteBuffer(arg0);
}

void RemoteGraphicsContextGL::deleteFramebuffer(uint32_t arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (!arg0) [[unlikely]]
        return;
    arg0 = m_objectNames.take(arg0);
    protectedContext()->deleteFramebuffer(arg0);
}

void RemoteGraphicsContextGL::deleteProgram(uint32_t arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (!arg0) [[unlikely]]
        return;
    arg0 = m_objectNames.take(arg0);
    protectedContext()->deleteProgram(arg0);
}

void RemoteGraphicsContextGL::deleteRenderbuffer(uint32_t arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (!arg0) [[unlikely]]
        return;
    arg0 = m_objectNames.take(arg0);
    protectedContext()->deleteRenderbuffer(arg0);
}

void RemoteGraphicsContextGL::deleteShader(uint32_t arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (!arg0) [[unlikely]]
        return;
    arg0 = m_objectNames.take(arg0);
    protectedContext()->deleteShader(arg0);
}

void RemoteGraphicsContextGL::deleteTexture(uint32_t arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (!arg0) [[unlikely]]
        return;
    arg0 = m_objectNames.take(arg0);
    protectedContext()->deleteTexture(arg0);
}

void RemoteGraphicsContextGL::depthFunc(uint32_t func)
{
    assertIsCurrent(workQueue());
    protectedContext()->depthFunc(func);
}

void RemoteGraphicsContextGL::depthMask(bool flag)
{
    assertIsCurrent(workQueue());
    protectedContext()->depthMask(static_cast<GCGLboolean>(flag));
}

void RemoteGraphicsContextGL::depthRange(float zNear, float zFar)
{
    assertIsCurrent(workQueue());
    protectedContext()->depthRange(zNear, zFar);
}

void RemoteGraphicsContextGL::detachShader(uint32_t arg0, uint32_t arg1)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    MESSAGE_CHECK(m_objectNames.isValidKey(arg1));
    if (arg1)
        arg1 = m_objectNames.get(arg1);
    protectedContext()->detachShader(arg0, arg1);
}

void RemoteGraphicsContextGL::disable(uint32_t cap)
{
    assertIsCurrent(workQueue());
    protectedContext()->disable(cap);
}

void RemoteGraphicsContextGL::disableVertexAttribArray(uint32_t index)
{
    assertIsCurrent(workQueue());
    protectedContext()->disableVertexAttribArray(index);
}

void RemoteGraphicsContextGL::drawArrays(uint32_t mode, int32_t first, int32_t count)
{
    assertIsCurrent(workQueue());
    protectedContext()->drawArrays(mode, first, count);
}

void RemoteGraphicsContextGL::drawElements(uint32_t mode, int32_t count, uint32_t type, uint64_t offset)
{
    assertIsCurrent(workQueue());
    protectedContext()->drawElements(mode, count, type, static_cast<GCGLintptr>(offset));
}

void RemoteGraphicsContextGL::enable(uint32_t cap)
{
    assertIsCurrent(workQueue());
    protectedContext()->enable(cap);
}

void RemoteGraphicsContextGL::enableVertexAttribArray(uint32_t index)
{
    assertIsCurrent(workQueue());
    protectedContext()->enableVertexAttribArray(index);
}

void RemoteGraphicsContextGL::finish()
{
    assertIsCurrent(workQueue());
    protectedContext()->finish();
}

void RemoteGraphicsContextGL::flush()
{
    assertIsCurrent(workQueue());
    protectedContext()->flush();
}

void RemoteGraphicsContextGL::framebufferRenderbuffer(uint32_t target, uint32_t attachment, uint32_t renderbuffertarget, uint32_t arg3)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg3));
    if (arg3)
        arg3 = m_objectNames.get(arg3);
    protectedContext()->framebufferRenderbuffer(target, attachment, renderbuffertarget, arg3);
}

void RemoteGraphicsContextGL::framebufferTexture2D(uint32_t target, uint32_t attachment, uint32_t textarget, uint32_t arg3, int32_t level)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg3));
    if (arg3)
        arg3 = m_objectNames.get(arg3);
    protectedContext()->framebufferTexture2D(target, attachment, textarget, arg3, level);
}

void RemoteGraphicsContextGL::frontFace(uint32_t mode)
{
    assertIsCurrent(workQueue());
    protectedContext()->frontFace(mode);
}

void RemoteGraphicsContextGL::generateMipmap(uint32_t target)
{
    assertIsCurrent(workQueue());
    protectedContext()->generateMipmap(target);
}

void RemoteGraphicsContextGL::activeAttribs(uint32_t program, CompletionHandler<void(Vector<WebCore::GCGLAttribActiveInfo>&&)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    Vector<WebCore::GCGLAttribActiveInfo> returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(program));
    if (program)
        program = m_objectNames.get(program);
    returnValue = protectedContext()->activeAttribs(program);
    completionHandler(WTF::move(returnValue));
}

void RemoteGraphicsContextGL::activeUniforms(uint32_t program, CompletionHandler<void(Vector<WebCore::GCGLUniformActiveInfo>&&)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    Vector<WebCore::GCGLUniformActiveInfo> returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(program));
    if (program)
        program = m_objectNames.get(program);
    returnValue = protectedContext()->activeUniforms(program);
    completionHandler(WTF::move(returnValue));
}

void RemoteGraphicsContextGL::getBufferParameteri(uint32_t target, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLint returnValue = { };
    returnValue = protectedContext()->getBufferParameteri(target, pname);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::getString(uint32_t name, CompletionHandler<void(CString&&)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    CString returnValue = { };
    returnValue = protectedContext()->getString(name);
    completionHandler(WTF::move(returnValue));
}

void RemoteGraphicsContextGL::getFloatv(uint32_t pname, uint64_t valueSize, CompletionHandler<void(std::span<const float>)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    if (!WTF::isValidCapacityForVector<GCGLfloat>(valueSize))
        valueSize = 16;
    Vector<GCGLfloat, 16> value(valueSize, 0);
    protectedContext()->getFloatv(pname, value);
    completionHandler(spanReinterpretCast<const float>(value.span()));
}

void RemoteGraphicsContextGL::getIntegerv(uint32_t pname, uint64_t valueSize, CompletionHandler<void(std::span<const int32_t>)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    if (!WTF::isValidCapacityForVector<GCGLint>(valueSize))
        valueSize = 4;
    Vector<GCGLint, 4> value(valueSize, 0);
    protectedContext()->getIntegerv(pname, value);
    completionHandler(spanReinterpretCast<const int32_t>(value.span()));
}

void RemoteGraphicsContextGL::getIntegeri_v(uint32_t pname, uint32_t index, CompletionHandler<void(std::span<const int32_t, 4>)>&& completionHandler) // NOLINT
{
    assertIsCurrent(workQueue());
    std::array<GCGLint, 4> value { };
    protectedContext()->getIntegeri_v(pname, index, value);
    completionHandler(spanReinterpretCast<const int32_t, 4>(std::span<const GCGLint, 4>(value)));
}

void RemoteGraphicsContextGL::getInteger64(uint32_t pname, CompletionHandler<void(int64_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLint64 returnValue = { };
    returnValue = protectedContext()->getInteger64(pname);
    completionHandler(static_cast<int64_t>(returnValue));
}

void RemoteGraphicsContextGL::getInteger64i(uint32_t pname, uint32_t index, CompletionHandler<void(int64_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLint64 returnValue = { };
    returnValue = protectedContext()->getInteger64i(pname, index);
    completionHandler(static_cast<int64_t>(returnValue));
}

void RemoteGraphicsContextGL::getProgrami(uint32_t program, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLint returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(program));
    if (program)
        program = m_objectNames.get(program);
    returnValue = protectedContext()->getProgrami(program, pname);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::getBooleanv(uint32_t pname, uint64_t valueSize, CompletionHandler<void(std::span<const bool>)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    if (!WTF::isValidCapacityForVector<GCGLboolean>(valueSize))
        valueSize = 4;
    Vector<GCGLboolean, 4> value(valueSize, 0);
    protectedContext()->getBooleanv(pname, value);
    completionHandler(spanReinterpretCast<const bool>(value.span()));
}

void RemoteGraphicsContextGL::getFramebufferAttachmentParameteri(uint32_t target, uint32_t attachment, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLint returnValue = { };
    returnValue = protectedContext()->getFramebufferAttachmentParameteri(target, attachment, pname);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::getProgramInfoLog(uint32_t arg0, CompletionHandler<void(CString&&)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    CString returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    returnValue = protectedContext()->getProgramInfoLog(arg0);
    completionHandler(WTF::move(returnValue));
}

void RemoteGraphicsContextGL::getRenderbufferParameteri(uint32_t target, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLint returnValue = { };
    returnValue = protectedContext()->getRenderbufferParameteri(target, pname);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::getShaderi(uint32_t arg0, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLint returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    returnValue = protectedContext()->getShaderi(arg0, pname);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::getShaderInfoLog(uint32_t arg0, CompletionHandler<void(CString&&)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    CString returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    returnValue = protectedContext()->getShaderInfoLog(arg0);
    completionHandler(WTF::move(returnValue));
}

void RemoteGraphicsContextGL::getShaderPrecisionFormat(uint32_t shaderType, uint32_t precisionType, CompletionHandler<void(std::span<const int32_t, 2>, int32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    std::array<GCGLint, 2> range { };
    GCGLint precision = { };
    protectedContext()->getShaderPrecisionFormat(shaderType, precisionType, range, &precision);
    completionHandler(spanReinterpretCast<const int32_t, 2>(std::span<const GCGLint, 2>(range)), precision);
}

void RemoteGraphicsContextGL::getTexParameterf(uint32_t target, uint32_t pname, CompletionHandler<void(float)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLfloat returnValue = { };
    returnValue = protectedContext()->getTexParameterf(target, pname);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::getTexParameteri(uint32_t target, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLint returnValue = { };
    returnValue = protectedContext()->getTexParameteri(target, pname);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::getUniformfv(uint32_t program, int32_t location, uint64_t valueSize, CompletionHandler<void(std::span<const float>)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(program));
    if (program)
        program = m_objectNames.get(program);
    if (!WTF::isValidCapacityForVector<GCGLfloat>(valueSize))
        valueSize = 16;
    Vector<GCGLfloat, 16> value(valueSize, 0);
    protectedContext()->getUniformfv(program, location, value);
    completionHandler(spanReinterpretCast<const float>(value.span()));
}

void RemoteGraphicsContextGL::getUniformiv(uint32_t program, int32_t location, uint64_t valueSize, CompletionHandler<void(std::span<const int32_t>)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(program));
    if (program)
        program = m_objectNames.get(program);
    if (!WTF::isValidCapacityForVector<GCGLint>(valueSize))
        valueSize = 4;
    Vector<GCGLint, 4> value(valueSize, 0);
    protectedContext()->getUniformiv(program, location, value);
    completionHandler(spanReinterpretCast<const int32_t>(value.span()));
}

void RemoteGraphicsContextGL::getUniformuiv(uint32_t program, int32_t location, uint64_t valueSize, CompletionHandler<void(std::span<const uint32_t>)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(program));
    if (program)
        program = m_objectNames.get(program);
    if (!WTF::isValidCapacityForVector<GCGLuint>(valueSize))
        valueSize = 4;
    Vector<GCGLuint, 4> value(valueSize, 0);
    protectedContext()->getUniformuiv(program, location, value);
    completionHandler(spanReinterpretCast<const uint32_t>(value.span()));
}

void RemoteGraphicsContextGL::getVertexAttribOffset(uint32_t index, uint32_t pname, CompletionHandler<void(uint64_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLsizeiptr returnValue = { };
    returnValue = protectedContext()->getVertexAttribOffset(index, pname);
    completionHandler(static_cast<uint64_t>(returnValue));
}

void RemoteGraphicsContextGL::hint(uint32_t target, uint32_t mode)
{
    assertIsCurrent(workQueue());
    protectedContext()->hint(target, mode);
}

void RemoteGraphicsContextGL::isBuffer(uint32_t arg0, CompletionHandler<void(bool)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLboolean returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    returnValue = protectedContext()->isBuffer(arg0);
    completionHandler(static_cast<bool>(returnValue));
}

void RemoteGraphicsContextGL::isEnabled(uint32_t cap, CompletionHandler<void(bool)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLboolean returnValue = { };
    returnValue = protectedContext()->isEnabled(cap);
    completionHandler(static_cast<bool>(returnValue));
}

void RemoteGraphicsContextGL::isFramebuffer(uint32_t arg0, CompletionHandler<void(bool)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLboolean returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    returnValue = protectedContext()->isFramebuffer(arg0);
    completionHandler(static_cast<bool>(returnValue));
}

void RemoteGraphicsContextGL::isProgram(uint32_t arg0, CompletionHandler<void(bool)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLboolean returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    returnValue = protectedContext()->isProgram(arg0);
    completionHandler(static_cast<bool>(returnValue));
}

void RemoteGraphicsContextGL::isRenderbuffer(uint32_t arg0, CompletionHandler<void(bool)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLboolean returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    returnValue = protectedContext()->isRenderbuffer(arg0);
    completionHandler(static_cast<bool>(returnValue));
}

void RemoteGraphicsContextGL::isShader(uint32_t arg0, CompletionHandler<void(bool)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLboolean returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    returnValue = protectedContext()->isShader(arg0);
    completionHandler(static_cast<bool>(returnValue));
}

void RemoteGraphicsContextGL::isTexture(uint32_t arg0, CompletionHandler<void(bool)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLboolean returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    returnValue = protectedContext()->isTexture(arg0);
    completionHandler(static_cast<bool>(returnValue));
}

void RemoteGraphicsContextGL::lineWidth(float arg0)
{
    assertIsCurrent(workQueue());
    protectedContext()->lineWidth(arg0);
}

void RemoteGraphicsContextGL::linkProgram(uint32_t arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    protectedContext()->linkProgram(arg0);
}

void RemoteGraphicsContextGL::pixelStorei(uint32_t pname, int32_t param)
{
    assertIsCurrent(workQueue());
    protectedContext()->pixelStorei(pname, param);
}

void RemoteGraphicsContextGL::polygonOffset(float factor, float units)
{
    assertIsCurrent(workQueue());
    protectedContext()->polygonOffset(factor, units);
}

void RemoteGraphicsContextGL::renderbufferStorage(uint32_t target, uint32_t internalformat, int32_t width, int32_t height)
{
    assertIsCurrent(workQueue());
    protectedContext()->renderbufferStorage(target, internalformat, width, height);
}

void RemoteGraphicsContextGL::sampleCoverage(float value, bool invert)
{
    assertIsCurrent(workQueue());
    protectedContext()->sampleCoverage(value, static_cast<GCGLboolean>(invert));
}

void RemoteGraphicsContextGL::scissor(int32_t x, int32_t y, int32_t width, int32_t height)
{
    assertIsCurrent(workQueue());
    protectedContext()->scissor(x, y, width, height);
}

void RemoteGraphicsContextGL::shaderSource(uint32_t arg0, CString&& arg1)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    protectedContext()->shaderSource(arg0, arg1);
}

void RemoteGraphicsContextGL::stencilFunc(uint32_t func, int32_t ref, uint32_t mask)
{
    assertIsCurrent(workQueue());
    protectedContext()->stencilFunc(func, ref, mask);
}

void RemoteGraphicsContextGL::stencilFuncSeparate(uint32_t face, uint32_t func, int32_t ref, uint32_t mask)
{
    assertIsCurrent(workQueue());
    protectedContext()->stencilFuncSeparate(face, func, ref, mask);
}

void RemoteGraphicsContextGL::stencilMask(uint32_t mask)
{
    assertIsCurrent(workQueue());
    protectedContext()->stencilMask(mask);
}

void RemoteGraphicsContextGL::stencilMaskSeparate(uint32_t face, uint32_t mask)
{
    assertIsCurrent(workQueue());
    protectedContext()->stencilMaskSeparate(face, mask);
}

void RemoteGraphicsContextGL::stencilOp(uint32_t fail, uint32_t zfail, uint32_t zpass)
{
    assertIsCurrent(workQueue());
    protectedContext()->stencilOp(fail, zfail, zpass);
}

void RemoteGraphicsContextGL::stencilOpSeparate(uint32_t face, uint32_t fail, uint32_t zfail, uint32_t zpass)
{
    assertIsCurrent(workQueue());
    protectedContext()->stencilOpSeparate(face, fail, zfail, zpass);
}

void RemoteGraphicsContextGL::texParameterf(uint32_t target, uint32_t pname, float param)
{
    assertIsCurrent(workQueue());
    protectedContext()->texParameterf(target, pname, param);
}

void RemoteGraphicsContextGL::texParameteri(uint32_t target, uint32_t pname, int32_t param)
{
    assertIsCurrent(workQueue());
    protectedContext()->texParameteri(target, pname, param);
}

void RemoteGraphicsContextGL::uniform1f(int32_t location, float x)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform1f(location, x);
}

void RemoteGraphicsContextGL::uniform1fv(int32_t location, std::span<const float>&& v)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform1fv(location, v);
}

void RemoteGraphicsContextGL::uniform1i(int32_t location, int32_t x)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform1i(location, x);
}

void RemoteGraphicsContextGL::uniform1iv(int32_t location, std::span<const int32_t>&& v)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform1iv(location, v);
}

void RemoteGraphicsContextGL::uniform2f(int32_t location, float x, float y)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform2f(location, x, y);
}

void RemoteGraphicsContextGL::uniform2fv(int32_t location, std::span<const float>&& v)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform2fv(location, v);
}

void RemoteGraphicsContextGL::uniform2i(int32_t location, int32_t x, int32_t y)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform2i(location, x, y);
}

void RemoteGraphicsContextGL::uniform2iv(int32_t location, std::span<const int32_t>&& v)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform2iv(location, v);
}

void RemoteGraphicsContextGL::uniform3f(int32_t location, float x, float y, float z)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform3f(location, x, y, z);
}

void RemoteGraphicsContextGL::uniform3fv(int32_t location, std::span<const float>&& v)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform3fv(location, v);
}

void RemoteGraphicsContextGL::uniform3i(int32_t location, int32_t x, int32_t y, int32_t z)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform3i(location, x, y, z);
}

void RemoteGraphicsContextGL::uniform3iv(int32_t location, std::span<const int32_t>&& v)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform3iv(location, v);
}

void RemoteGraphicsContextGL::uniform4f(int32_t location, float x, float y, float z, float w)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform4f(location, x, y, z, w);
}

void RemoteGraphicsContextGL::uniform4fv(int32_t location, std::span<const float>&& v)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform4fv(location, v);
}

void RemoteGraphicsContextGL::uniform4i(int32_t location, int32_t x, int32_t y, int32_t z, int32_t w)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform4i(location, x, y, z, w);
}

void RemoteGraphicsContextGL::uniform4iv(int32_t location, std::span<const int32_t>&& v)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform4iv(location, v);
}

void RemoteGraphicsContextGL::uniformMatrix2fv(int32_t location, bool transpose, std::span<const float>&& value)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniformMatrix2fv(location, static_cast<GCGLboolean>(transpose), value);
}

void RemoteGraphicsContextGL::uniformMatrix3fv(int32_t location, bool transpose, std::span<const float>&& value)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniformMatrix3fv(location, static_cast<GCGLboolean>(transpose), value);
}

void RemoteGraphicsContextGL::uniformMatrix4fv(int32_t location, bool transpose, std::span<const float>&& value)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniformMatrix4fv(location, static_cast<GCGLboolean>(transpose), value);
}

void RemoteGraphicsContextGL::useProgram(uint32_t arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    protectedContext()->useProgram(arg0);
}

void RemoteGraphicsContextGL::validateProgram(uint32_t arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    protectedContext()->validateProgram(arg0);
}

void RemoteGraphicsContextGL::vertexAttrib1f(uint32_t index, float x)
{
    assertIsCurrent(workQueue());
    protectedContext()->vertexAttrib1f(index, x);
}

void RemoteGraphicsContextGL::vertexAttrib1fv(uint32_t index, std::span<const float, 1>&& values)
{
    assertIsCurrent(workQueue());
    protectedContext()->vertexAttrib1fv(index, values);
}

void RemoteGraphicsContextGL::vertexAttrib2f(uint32_t index, float x, float y)
{
    assertIsCurrent(workQueue());
    protectedContext()->vertexAttrib2f(index, x, y);
}

void RemoteGraphicsContextGL::vertexAttrib2fv(uint32_t index, std::span<const float, 2>&& values)
{
    assertIsCurrent(workQueue());
    protectedContext()->vertexAttrib2fv(index, values);
}

void RemoteGraphicsContextGL::vertexAttrib3f(uint32_t index, float x, float y, float z)
{
    assertIsCurrent(workQueue());
    protectedContext()->vertexAttrib3f(index, x, y, z);
}

void RemoteGraphicsContextGL::vertexAttrib3fv(uint32_t index, std::span<const float, 3>&& values)
{
    assertIsCurrent(workQueue());
    protectedContext()->vertexAttrib3fv(index, values);
}

void RemoteGraphicsContextGL::vertexAttrib4f(uint32_t index, float x, float y, float z, float w)
{
    assertIsCurrent(workQueue());
    protectedContext()->vertexAttrib4f(index, x, y, z, w);
}

void RemoteGraphicsContextGL::vertexAttrib4fv(uint32_t index, std::span<const float, 4>&& values)
{
    assertIsCurrent(workQueue());
    protectedContext()->vertexAttrib4fv(index, values);
}

void RemoteGraphicsContextGL::vertexAttribPointer(uint32_t index, int32_t size, uint32_t type, bool normalized, int32_t stride, uint64_t offset)
{
    assertIsCurrent(workQueue());
    protectedContext()->vertexAttribPointer(index, size, type, static_cast<GCGLboolean>(normalized), stride, static_cast<GCGLintptr>(offset));
}

void RemoteGraphicsContextGL::viewport(int32_t x, int32_t y, int32_t width, int32_t height)
{
    assertIsCurrent(workQueue());
    protectedContext()->viewport(x, y, width, height);
}

void RemoteGraphicsContextGL::bufferData0(uint32_t target, uint64_t arg1, uint32_t usage)
{
    assertIsCurrent(workQueue());
    protectedContext()->bufferData(target, static_cast<GCGLsizeiptr>(arg1), usage);
}

void RemoteGraphicsContextGL::bufferData1(uint32_t target, std::span<const uint8_t>&& data, uint32_t usage)
{
    assertIsCurrent(workQueue());
    protectedContext()->bufferData(target, data, usage);
}

void RemoteGraphicsContextGL::bufferSubData(uint32_t target, uint64_t offset, std::span<const uint8_t>&& data)
{
    assertIsCurrent(workQueue());
    protectedContext()->bufferSubData(target, static_cast<GCGLintptr>(offset), data);
}

void RemoteGraphicsContextGL::readPixelsBufferObject(WebCore::IntRect&& arg0, uint32_t format, uint32_t type, uint64_t offset, int32_t alignment, int32_t rowLength)
{
    assertIsCurrent(workQueue());
    protectedContext()->readPixelsBufferObject(arg0, format, type, static_cast<GCGLintptr>(offset), alignment, rowLength);
}

void RemoteGraphicsContextGL::texImage2D0(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t border, uint32_t format, uint32_t type, std::span<const uint8_t>&& pixels)
{
    assertIsCurrent(workQueue());
    protectedContext()->texImage2D(target, level, internalformat, width, height, border, format, type, pixels);
}

void RemoteGraphicsContextGL::texImage2D1(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t border, uint32_t format, uint32_t type, uint64_t offset)
{
    assertIsCurrent(workQueue());
    protectedContext()->texImage2D(target, level, internalformat, width, height, border, format, type, static_cast<GCGLintptr>(offset));
}

void RemoteGraphicsContextGL::texSubImage2D0(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t width, int32_t height, uint32_t format, uint32_t type, std::span<const uint8_t>&& pixels)
{
    assertIsCurrent(workQueue());
    protectedContext()->texSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
}

void RemoteGraphicsContextGL::texSubImage2D1(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t width, int32_t height, uint32_t format, uint32_t type, uint64_t offset)
{
    assertIsCurrent(workQueue());
    protectedContext()->texSubImage2D(target, level, xoffset, yoffset, width, height, format, type, static_cast<GCGLintptr>(offset));
}

void RemoteGraphicsContextGL::compressedTexImage2D0(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t border, int32_t imageSize, std::span<const uint8_t>&& data)
{
    assertIsCurrent(workQueue());
    protectedContext()->compressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
}

void RemoteGraphicsContextGL::compressedTexImage2D1(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t border, int32_t imageSize, uint64_t offset)
{
    assertIsCurrent(workQueue());
    protectedContext()->compressedTexImage2D(target, level, internalformat, width, height, border, imageSize, static_cast<GCGLintptr>(offset));
}

void RemoteGraphicsContextGL::compressedTexSubImage2D0(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t width, int32_t height, uint32_t format, int32_t imageSize, std::span<const uint8_t>&& data)
{
    assertIsCurrent(workQueue());
    protectedContext()->compressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
}

void RemoteGraphicsContextGL::compressedTexSubImage2D1(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t width, int32_t height, uint32_t format, int32_t imageSize, uint64_t offset)
{
    assertIsCurrent(workQueue());
    protectedContext()->compressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, static_cast<GCGLintptr>(offset));
}

void RemoteGraphicsContextGL::drawArraysInstanced(uint32_t mode, int32_t first, int32_t count, int32_t primcount)
{
    assertIsCurrent(workQueue());
    protectedContext()->drawArraysInstanced(mode, first, count, primcount);
}

void RemoteGraphicsContextGL::drawElementsInstanced(uint32_t mode, int32_t count, uint32_t type, uint64_t offset, int32_t primcount)
{
    assertIsCurrent(workQueue());
    protectedContext()->drawElementsInstanced(mode, count, type, static_cast<GCGLintptr>(offset), primcount);
}

void RemoteGraphicsContextGL::vertexAttribDivisor(uint32_t index, uint32_t divisor)
{
    assertIsCurrent(workQueue());
    protectedContext()->vertexAttribDivisor(index, divisor);
}

void RemoteGraphicsContextGL::createVertexArray(uint32_t name)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(name));
    auto result = protectedContext()->createVertexArray();
    if (result)
        m_objectNames.add(name, result);
}

void RemoteGraphicsContextGL::deleteVertexArray(uint32_t arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (!arg0) [[unlikely]]
        return;
    arg0 = m_objectNames.take(arg0);
    protectedContext()->deleteVertexArray(arg0);
}

void RemoteGraphicsContextGL::isVertexArray(uint32_t arg0, CompletionHandler<void(bool)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLboolean returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    returnValue = protectedContext()->isVertexArray(arg0);
    completionHandler(static_cast<bool>(returnValue));
}

void RemoteGraphicsContextGL::bindVertexArray(uint32_t arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    protectedContext()->bindVertexArray(arg0);
}

void RemoteGraphicsContextGL::copyBufferSubData(uint32_t readTarget, uint32_t writeTarget, uint64_t readOffset, uint64_t writeOffset, uint64_t arg4)
{
    assertIsCurrent(workQueue());
    protectedContext()->copyBufferSubData(readTarget, writeTarget, static_cast<GCGLintptr>(readOffset), static_cast<GCGLintptr>(writeOffset), static_cast<GCGLsizeiptr>(arg4));
}

void RemoteGraphicsContextGL::blitFramebuffer(int32_t srcX0, int32_t srcY0, int32_t srcX1, int32_t srcY1, int32_t dstX0, int32_t dstY0, int32_t dstX1, int32_t dstY1, uint32_t mask, uint32_t filter)
{
    assertIsCurrent(workQueue());
    protectedContext()->blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
}

void RemoteGraphicsContextGL::framebufferTextureLayer(uint32_t target, uint32_t attachment, uint32_t texture, int32_t level, int32_t layer)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(texture));
    if (texture)
        texture = m_objectNames.get(texture);
    protectedContext()->framebufferTextureLayer(target, attachment, texture, level, layer);
}

void RemoteGraphicsContextGL::readBuffer(uint32_t src)
{
    assertIsCurrent(workQueue());
    protectedContext()->readBuffer(src);
}

void RemoteGraphicsContextGL::renderbufferStorageMultisample(uint32_t target, int32_t samples, uint32_t internalformat, int32_t width, int32_t height)
{
    assertIsCurrent(workQueue());
    protectedContext()->renderbufferStorageMultisample(target, samples, internalformat, width, height);
}

void RemoteGraphicsContextGL::texStorage2D(uint32_t target, int32_t levels, uint32_t internalformat, int32_t width, int32_t height)
{
    assertIsCurrent(workQueue());
    protectedContext()->texStorage2D(target, levels, internalformat, width, height);
}

void RemoteGraphicsContextGL::texStorage3D(uint32_t target, int32_t levels, uint32_t internalformat, int32_t width, int32_t height, int32_t depth)
{
    assertIsCurrent(workQueue());
    protectedContext()->texStorage3D(target, levels, internalformat, width, height, depth);
}

void RemoteGraphicsContextGL::texImage3D0(uint32_t target, int32_t level, int32_t internalformat, int32_t width, int32_t height, int32_t depth, int32_t border, uint32_t format, uint32_t type, std::span<const uint8_t>&& pixels)
{
    assertIsCurrent(workQueue());
    protectedContext()->texImage3D(target, level, internalformat, width, height, depth, border, format, type, pixels);
}

void RemoteGraphicsContextGL::texImage3D1(uint32_t target, int32_t level, int32_t internalformat, int32_t width, int32_t height, int32_t depth, int32_t border, uint32_t format, uint32_t type, uint64_t offset)
{
    assertIsCurrent(workQueue());
    protectedContext()->texImage3D(target, level, internalformat, width, height, depth, border, format, type, static_cast<GCGLintptr>(offset));
}

void RemoteGraphicsContextGL::texSubImage3D0(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t zoffset, int32_t width, int32_t height, int32_t depth, uint32_t format, uint32_t type, std::span<const uint8_t>&& pixels)
{
    assertIsCurrent(workQueue());
    protectedContext()->texSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
}

void RemoteGraphicsContextGL::texSubImage3D1(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t zoffset, int32_t width, int32_t height, int32_t depth, uint32_t format, uint32_t type, uint64_t offset)
{
    assertIsCurrent(workQueue());
    protectedContext()->texSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, static_cast<GCGLintptr>(offset));
}

void RemoteGraphicsContextGL::copyTexSubImage3D(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t zoffset, int32_t x, int32_t y, int32_t width, int32_t height)
{
    assertIsCurrent(workQueue());
    protectedContext()->copyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
}

void RemoteGraphicsContextGL::compressedTexImage3D0(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t depth, int32_t border, int32_t imageSize, std::span<const uint8_t>&& data)
{
    assertIsCurrent(workQueue());
    protectedContext()->compressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, data);
}

void RemoteGraphicsContextGL::compressedTexImage3D1(uint32_t target, int32_t level, uint32_t internalformat, int32_t width, int32_t height, int32_t depth, int32_t border, int32_t imageSize, uint64_t offset)
{
    assertIsCurrent(workQueue());
    protectedContext()->compressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, static_cast<GCGLintptr>(offset));
}

void RemoteGraphicsContextGL::compressedTexSubImage3D0(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t zoffset, int32_t width, int32_t height, int32_t depth, uint32_t format, int32_t imageSize, std::span<const uint8_t>&& data)
{
    assertIsCurrent(workQueue());
    protectedContext()->compressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
}

void RemoteGraphicsContextGL::compressedTexSubImage3D1(uint32_t target, int32_t level, int32_t xoffset, int32_t yoffset, int32_t zoffset, int32_t width, int32_t height, int32_t depth, uint32_t format, int32_t imageSize, uint64_t offset)
{
    assertIsCurrent(workQueue());
    protectedContext()->compressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, static_cast<GCGLintptr>(offset));
}

void RemoteGraphicsContextGL::getFragDataLocation(uint32_t program, CString&& name, CompletionHandler<void(int32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLint returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(program));
    if (program)
        program = m_objectNames.get(program);
    returnValue = protectedContext()->getFragDataLocation(program, name);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::uniform1ui(int32_t location, uint32_t v0)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform1ui(location, v0);
}

void RemoteGraphicsContextGL::uniform2ui(int32_t location, uint32_t v0, uint32_t v1)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform2ui(location, v0, v1);
}

void RemoteGraphicsContextGL::uniform3ui(int32_t location, uint32_t v0, uint32_t v1, uint32_t v2)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform3ui(location, v0, v1, v2);
}

void RemoteGraphicsContextGL::uniform4ui(int32_t location, uint32_t v0, uint32_t v1, uint32_t v2, uint32_t v3)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform4ui(location, v0, v1, v2, v3);
}

void RemoteGraphicsContextGL::uniform1uiv(int32_t location, std::span<const uint32_t>&& data)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform1uiv(location, data);
}

void RemoteGraphicsContextGL::uniform2uiv(int32_t location, std::span<const uint32_t>&& data)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform2uiv(location, data);
}

void RemoteGraphicsContextGL::uniform3uiv(int32_t location, std::span<const uint32_t>&& data)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform3uiv(location, data);
}

void RemoteGraphicsContextGL::uniform4uiv(int32_t location, std::span<const uint32_t>&& data)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniform4uiv(location, data);
}

void RemoteGraphicsContextGL::uniformMatrix2x3fv(int32_t location, bool transpose, std::span<const float>&& data)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniformMatrix2x3fv(location, static_cast<GCGLboolean>(transpose), data);
}

void RemoteGraphicsContextGL::uniformMatrix3x2fv(int32_t location, bool transpose, std::span<const float>&& data)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniformMatrix3x2fv(location, static_cast<GCGLboolean>(transpose), data);
}

void RemoteGraphicsContextGL::uniformMatrix2x4fv(int32_t location, bool transpose, std::span<const float>&& data)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniformMatrix2x4fv(location, static_cast<GCGLboolean>(transpose), data);
}

void RemoteGraphicsContextGL::uniformMatrix4x2fv(int32_t location, bool transpose, std::span<const float>&& data)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniformMatrix4x2fv(location, static_cast<GCGLboolean>(transpose), data);
}

void RemoteGraphicsContextGL::uniformMatrix3x4fv(int32_t location, bool transpose, std::span<const float>&& data)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniformMatrix3x4fv(location, static_cast<GCGLboolean>(transpose), data);
}

void RemoteGraphicsContextGL::uniformMatrix4x3fv(int32_t location, bool transpose, std::span<const float>&& data)
{
    assertIsCurrent(workQueue());
    protectedContext()->uniformMatrix4x3fv(location, static_cast<GCGLboolean>(transpose), data);
}

void RemoteGraphicsContextGL::vertexAttribI4i(uint32_t index, int32_t x, int32_t y, int32_t z, int32_t w)
{
    assertIsCurrent(workQueue());
    protectedContext()->vertexAttribI4i(index, x, y, z, w);
}

void RemoteGraphicsContextGL::vertexAttribI4iv(uint32_t index, std::span<const int32_t, 4>&& values)
{
    assertIsCurrent(workQueue());
    protectedContext()->vertexAttribI4iv(index, values);
}

void RemoteGraphicsContextGL::vertexAttribI4ui(uint32_t index, uint32_t x, uint32_t y, uint32_t z, uint32_t w)
{
    assertIsCurrent(workQueue());
    protectedContext()->vertexAttribI4ui(index, x, y, z, w);
}

void RemoteGraphicsContextGL::vertexAttribI4uiv(uint32_t index, std::span<const uint32_t, 4>&& values)
{
    assertIsCurrent(workQueue());
    protectedContext()->vertexAttribI4uiv(index, values);
}

void RemoteGraphicsContextGL::vertexAttribIPointer(uint32_t index, int32_t size, uint32_t type, int32_t stride, uint64_t offset)
{
    assertIsCurrent(workQueue());
    protectedContext()->vertexAttribIPointer(index, size, type, stride, static_cast<GCGLintptr>(offset));
}

void RemoteGraphicsContextGL::drawRangeElements(uint32_t mode, uint32_t start, uint32_t end, int32_t count, uint32_t type, uint64_t offset)
{
    assertIsCurrent(workQueue());
    protectedContext()->drawRangeElements(mode, start, end, count, type, static_cast<GCGLintptr>(offset));
}

void RemoteGraphicsContextGL::clearBufferiv(uint32_t buffer, int32_t drawbuffer, std::span<const int32_t>&& values)
{
    assertIsCurrent(workQueue());
    protectedContext()->clearBufferiv(buffer, drawbuffer, values);
}

void RemoteGraphicsContextGL::clearBufferuiv(uint32_t buffer, int32_t drawbuffer, std::span<const uint32_t>&& values)
{
    assertIsCurrent(workQueue());
    protectedContext()->clearBufferuiv(buffer, drawbuffer, values);
}

void RemoteGraphicsContextGL::clearBufferfv(uint32_t buffer, int32_t drawbuffer, std::span<const float>&& values)
{
    assertIsCurrent(workQueue());
    protectedContext()->clearBufferfv(buffer, drawbuffer, values);
}

void RemoteGraphicsContextGL::clearBufferfi(uint32_t buffer, int32_t drawbuffer, float depth, int32_t stencil)
{
    assertIsCurrent(workQueue());
    protectedContext()->clearBufferfi(buffer, drawbuffer, depth, stencil);
}

void RemoteGraphicsContextGL::createQuery(uint32_t name)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(name));
    auto result = protectedContext()->createQuery();
    if (result)
        m_objectNames.add(name, result);
}

void RemoteGraphicsContextGL::deleteQuery(uint32_t query)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(query));
    if (!query) [[unlikely]]
        return;
    query = m_objectNames.take(query);
    protectedContext()->deleteQuery(query);
}

void RemoteGraphicsContextGL::isQuery(uint32_t query, CompletionHandler<void(bool)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLboolean returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(query));
    if (query)
        query = m_objectNames.get(query);
    returnValue = protectedContext()->isQuery(query);
    completionHandler(static_cast<bool>(returnValue));
}

void RemoteGraphicsContextGL::beginQuery(uint32_t target, uint32_t query)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(query));
    if (query)
        query = m_objectNames.get(query);
    protectedContext()->beginQuery(target, query);
}

void RemoteGraphicsContextGL::endQuery(uint32_t target)
{
    assertIsCurrent(workQueue());
    protectedContext()->endQuery(target);
}

void RemoteGraphicsContextGL::getQuery(uint32_t target, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLint returnValue = { };
    returnValue = protectedContext()->getQuery(target, pname);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::getQueryObjectui(uint32_t query, uint32_t pname, CompletionHandler<void(uint32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLuint returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(query));
    if (query)
        query = m_objectNames.get(query);
    returnValue = protectedContext()->getQueryObjectui(query, pname);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::createSampler(uint32_t name)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(name));
    auto result = protectedContext()->createSampler();
    if (result)
        m_objectNames.add(name, result);
}

void RemoteGraphicsContextGL::deleteSampler(uint32_t sampler)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(sampler));
    if (!sampler) [[unlikely]]
        return;
    sampler = m_objectNames.take(sampler);
    protectedContext()->deleteSampler(sampler);
}

void RemoteGraphicsContextGL::isSampler(uint32_t sampler, CompletionHandler<void(bool)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLboolean returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(sampler));
    if (sampler)
        sampler = m_objectNames.get(sampler);
    returnValue = protectedContext()->isSampler(sampler);
    completionHandler(static_cast<bool>(returnValue));
}

void RemoteGraphicsContextGL::bindSampler(uint32_t unit, uint32_t sampler)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(sampler));
    if (sampler)
        sampler = m_objectNames.get(sampler);
    protectedContext()->bindSampler(unit, sampler);
}

void RemoteGraphicsContextGL::samplerParameteri(uint32_t sampler, uint32_t pname, int32_t param)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(sampler));
    if (sampler)
        sampler = m_objectNames.get(sampler);
    protectedContext()->samplerParameteri(sampler, pname, param);
}

void RemoteGraphicsContextGL::samplerParameterf(uint32_t sampler, uint32_t pname, float param)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(sampler));
    if (sampler)
        sampler = m_objectNames.get(sampler);
    protectedContext()->samplerParameterf(sampler, pname, param);
}

void RemoteGraphicsContextGL::getSamplerParameterf(uint32_t sampler, uint32_t pname, CompletionHandler<void(float)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLfloat returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(sampler));
    if (sampler)
        sampler = m_objectNames.get(sampler);
    returnValue = protectedContext()->getSamplerParameterf(sampler, pname);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::getSamplerParameteri(uint32_t sampler, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLint returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(sampler));
    if (sampler)
        sampler = m_objectNames.get(sampler);
    returnValue = protectedContext()->getSamplerParameteri(sampler, pname);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::fenceSync(uint32_t condition, uint32_t flags, CompletionHandler<void(uint64_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLsync returnValue = { };
    returnValue = protectedContext()->fenceSync(condition, flags);
    completionHandler(static_cast<uint64_t>(reinterpret_cast<intptr_t>(returnValue)));
}

void RemoteGraphicsContextGL::isSync(uint64_t arg0, CompletionHandler<void(bool)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLboolean returnValue = { };
    returnValue = protectedContext()->isSync(reinterpret_cast<GCGLsync>(static_cast<intptr_t>(arg0)));
    completionHandler(static_cast<bool>(returnValue));
}

void RemoteGraphicsContextGL::deleteSync(uint64_t arg0)
{
    assertIsCurrent(workQueue());
    protectedContext()->deleteSync(reinterpret_cast<GCGLsync>(static_cast<intptr_t>(arg0)));
}

void RemoteGraphicsContextGL::clientWaitSync(uint64_t arg0, uint32_t flags, uint64_t timeout, CompletionHandler<void(uint32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLenum returnValue = { };
    returnValue = protectedContext()->clientWaitSync(reinterpret_cast<GCGLsync>(static_cast<intptr_t>(arg0)), flags, static_cast<GCGLuint64>(timeout));
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::waitSync(uint64_t arg0, uint32_t flags, int64_t timeout)
{
    assertIsCurrent(workQueue());
    protectedContext()->waitSync(reinterpret_cast<GCGLsync>(static_cast<intptr_t>(arg0)), flags, static_cast<GCGLint64>(timeout));
}

void RemoteGraphicsContextGL::getSynci(uint64_t arg0, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLint returnValue = { };
    returnValue = protectedContext()->getSynci(reinterpret_cast<GCGLsync>(static_cast<intptr_t>(arg0)), pname);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::createTransformFeedback(uint32_t name)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(name));
    auto result = protectedContext()->createTransformFeedback();
    if (result)
        m_objectNames.add(name, result);
}

void RemoteGraphicsContextGL::deleteTransformFeedback(uint32_t id)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(id));
    if (!id) [[unlikely]]
        return;
    id = m_objectNames.take(id);
    protectedContext()->deleteTransformFeedback(id);
}

void RemoteGraphicsContextGL::isTransformFeedback(uint32_t id, CompletionHandler<void(bool)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLboolean returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(id));
    if (id)
        id = m_objectNames.get(id);
    returnValue = protectedContext()->isTransformFeedback(id);
    completionHandler(static_cast<bool>(returnValue));
}

void RemoteGraphicsContextGL::bindTransformFeedback(uint32_t target, uint32_t id)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(id));
    if (id)
        id = m_objectNames.get(id);
    protectedContext()->bindTransformFeedback(target, id);
}

void RemoteGraphicsContextGL::beginTransformFeedback(uint32_t primitiveMode)
{
    assertIsCurrent(workQueue());
    protectedContext()->beginTransformFeedback(primitiveMode);
}

void RemoteGraphicsContextGL::endTransformFeedback()
{
    assertIsCurrent(workQueue());
    protectedContext()->endTransformFeedback();
}

void RemoteGraphicsContextGL::transformFeedbackVaryings(uint32_t program, Vector<CString>&& varyings, uint32_t bufferMode)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(program));
    if (program)
        program = m_objectNames.get(program);
    protectedContext()->transformFeedbackVaryings(program, varyings, bufferMode);
}

void RemoteGraphicsContextGL::getTransformFeedbackVarying(uint32_t program, uint32_t index, CompletionHandler<void(std::optional<WebCore::GCGLTransformFeedbackActiveInfo>&&)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    std::optional<WebCore::GCGLTransformFeedbackActiveInfo> returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(program));
    if (program)
        program = m_objectNames.get(program);
    returnValue = protectedContext()->getTransformFeedbackVarying(program, index);
    completionHandler(WTF::move(returnValue));
}

void RemoteGraphicsContextGL::pauseTransformFeedback()
{
    assertIsCurrent(workQueue());
    protectedContext()->pauseTransformFeedback();
}

void RemoteGraphicsContextGL::resumeTransformFeedback()
{
    assertIsCurrent(workQueue());
    protectedContext()->resumeTransformFeedback();
}

void RemoteGraphicsContextGL::bindBufferBase(uint32_t target, uint32_t index, uint32_t buffer)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(buffer));
    if (buffer)
        buffer = m_objectNames.get(buffer);
    protectedContext()->bindBufferBase(target, index, buffer);
}

void RemoteGraphicsContextGL::bindBufferRange(uint32_t target, uint32_t index, uint32_t buffer, uint64_t offset, uint64_t arg4)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(buffer));
    if (buffer)
        buffer = m_objectNames.get(buffer);
    protectedContext()->bindBufferRange(target, index, buffer, static_cast<GCGLintptr>(offset), static_cast<GCGLsizeiptr>(arg4));
}

void RemoteGraphicsContextGL::getUniformBlockIndex(uint32_t program, CString&& uniformBlockName, CompletionHandler<void(uint32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLuint returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(program));
    if (program)
        program = m_objectNames.get(program);
    returnValue = protectedContext()->getUniformBlockIndex(program, uniformBlockName);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::getActiveUniformBlockName(uint32_t program, uint32_t uniformBlockIndex, CompletionHandler<void(CString&&)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    CString returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(program));
    if (program)
        program = m_objectNames.get(program);
    returnValue = protectedContext()->getActiveUniformBlockName(program, uniformBlockIndex);
    completionHandler(WTF::move(returnValue));
}

void RemoteGraphicsContextGL::uniformBlockBinding(uint32_t program, uint32_t uniformBlockIndex, uint32_t uniformBlockBinding)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(program));
    if (program)
        program = m_objectNames.get(program);
    protectedContext()->uniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding);
}

void RemoteGraphicsContextGL::getActiveUniformBlockiv(uint32_t program, uint32_t uniformBlockIndex, uint32_t pname, uint64_t paramsSize, CompletionHandler<void(std::span<const int32_t>)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(program));
    if (program)
        program = m_objectNames.get(program);
    if (!WTF::isValidCapacityForVector<GCGLint>(paramsSize))
        paramsSize = 4;
    Vector<GCGLint, 4> params(paramsSize, 0);
    protectedContext()->getActiveUniformBlockiv(program, uniformBlockIndex, pname, params);
    completionHandler(spanReinterpretCast<const int32_t>(params.span()));
}

void RemoteGraphicsContextGL::getTranslatedShaderSourceANGLE(uint32_t arg0, CompletionHandler<void(CString&&)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    CString returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    returnValue = protectedContext()->getTranslatedShaderSourceANGLE(arg0);
    completionHandler(WTF::move(returnValue));
}

void RemoteGraphicsContextGL::createQueryEXT(uint32_t name)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(name));
    auto result = protectedContext()->createQueryEXT();
    if (result)
        m_objectNames.add(name, result);
}

void RemoteGraphicsContextGL::deleteQueryEXT(uint32_t query)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(query));
    if (!query) [[unlikely]]
        return;
    query = m_objectNames.take(query);
    protectedContext()->deleteQueryEXT(query);
}

void RemoteGraphicsContextGL::isQueryEXT(uint32_t query, CompletionHandler<void(bool)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLboolean returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(query));
    if (query)
        query = m_objectNames.get(query);
    returnValue = protectedContext()->isQueryEXT(query);
    completionHandler(static_cast<bool>(returnValue));
}

void RemoteGraphicsContextGL::beginQueryEXT(uint32_t target, uint32_t query)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(query));
    if (query)
        query = m_objectNames.get(query);
    protectedContext()->beginQueryEXT(target, query);
}

void RemoteGraphicsContextGL::endQueryEXT(uint32_t target)
{
    assertIsCurrent(workQueue());
    protectedContext()->endQueryEXT(target);
}

void RemoteGraphicsContextGL::queryCounterEXT(uint32_t query, uint32_t target)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(m_objectNames.isValidKey(query));
    if (query)
        query = m_objectNames.get(query);
    protectedContext()->queryCounterEXT(query, target);
}

void RemoteGraphicsContextGL::getQueryiEXT(uint32_t target, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLint returnValue = { };
    returnValue = protectedContext()->getQueryiEXT(target, pname);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::getQueryObjectiEXT(uint32_t query, uint32_t pname, CompletionHandler<void(int32_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLint returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(query));
    if (query)
        query = m_objectNames.get(query);
    returnValue = protectedContext()->getQueryObjectiEXT(query, pname);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::getQueryObjectui64EXT(uint32_t query, uint32_t pname, CompletionHandler<void(uint64_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLuint64 returnValue = { };
    MESSAGE_CHECK(m_objectNames.isValidKey(query));
    if (query)
        query = m_objectNames.get(query);
    returnValue = protectedContext()->getQueryObjectui64EXT(query, pname);
    completionHandler(static_cast<uint64_t>(returnValue));
}

void RemoteGraphicsContextGL::getInteger64EXT(uint32_t pname, CompletionHandler<void(int64_t)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    GCGLint64 returnValue = { };
    returnValue = protectedContext()->getInteger64EXT(pname);
    completionHandler(static_cast<int64_t>(returnValue));
}

void RemoteGraphicsContextGL::enableiOES(uint32_t target, uint32_t index)
{
    assertIsCurrent(workQueue());
    protectedContext()->enableiOES(target, index);
}

void RemoteGraphicsContextGL::disableiOES(uint32_t target, uint32_t index)
{
    assertIsCurrent(workQueue());
    protectedContext()->disableiOES(target, index);
}

void RemoteGraphicsContextGL::blendEquationiOES(uint32_t buf, uint32_t mode)
{
    assertIsCurrent(workQueue());
    protectedContext()->blendEquationiOES(buf, mode);
}

void RemoteGraphicsContextGL::blendEquationSeparateiOES(uint32_t buf, uint32_t modeRGB, uint32_t modeAlpha)
{
    assertIsCurrent(workQueue());
    protectedContext()->blendEquationSeparateiOES(buf, modeRGB, modeAlpha);
}

void RemoteGraphicsContextGL::blendFunciOES(uint32_t buf, uint32_t src, uint32_t dst)
{
    assertIsCurrent(workQueue());
    protectedContext()->blendFunciOES(buf, src, dst);
}

void RemoteGraphicsContextGL::blendFuncSeparateiOES(uint32_t buf, uint32_t srcRGB, uint32_t dstRGB, uint32_t srcAlpha, uint32_t dstAlpha)
{
    assertIsCurrent(workQueue());
    protectedContext()->blendFuncSeparateiOES(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
}

void RemoteGraphicsContextGL::colorMaskiOES(uint32_t buf, bool red, bool green, bool blue, bool alpha)
{
    assertIsCurrent(workQueue());
    protectedContext()->colorMaskiOES(buf, static_cast<GCGLboolean>(red), static_cast<GCGLboolean>(green), static_cast<GCGLboolean>(blue), static_cast<GCGLboolean>(alpha));
}

void RemoteGraphicsContextGL::drawArraysInstancedBaseInstanceANGLE(uint32_t mode, int32_t first, int32_t count, int32_t instanceCount, uint32_t baseInstance)
{
    assertIsCurrent(workQueue());
    protectedContext()->drawArraysInstancedBaseInstanceANGLE(mode, first, count, instanceCount, baseInstance);
}

void RemoteGraphicsContextGL::drawElementsInstancedBaseVertexBaseInstanceANGLE(uint32_t mode, int32_t count, uint32_t type, uint64_t offset, int32_t instanceCount, int32_t baseVertex, uint32_t baseInstance)
{
    assertIsCurrent(workQueue());
    protectedContext()->drawElementsInstancedBaseVertexBaseInstanceANGLE(mode, count, type, static_cast<GCGLintptr>(offset), instanceCount, baseVertex, baseInstance);
}

void RemoteGraphicsContextGL::clipControlEXT(uint32_t origin, uint32_t depth)
{
    assertIsCurrent(workQueue());
    protectedContext()->clipControlEXT(origin, depth);
}

void RemoteGraphicsContextGL::provokingVertexANGLE(uint32_t provokeMode)
{
    assertIsCurrent(workQueue());
    protectedContext()->provokingVertexANGLE(provokeMode);
}

void RemoteGraphicsContextGL::polygonModeANGLE(uint32_t face, uint32_t mode)
{
    assertIsCurrent(workQueue());
    protectedContext()->polygonModeANGLE(face, mode);
}

void RemoteGraphicsContextGL::polygonOffsetClampEXT(float factor, float units, float clamp)
{
    assertIsCurrent(workQueue());
    protectedContext()->polygonOffsetClampEXT(factor, units, clamp);
}

void RemoteGraphicsContextGL::renderbufferStorageMultisampleANGLE(uint32_t target, int32_t samples, uint32_t internalformat, int32_t width, int32_t height)
{
    assertIsCurrent(workQueue());
    protectedContext()->renderbufferStorageMultisampleANGLE(target, samples, internalformat, width, height);
}

void RemoteGraphicsContextGL::getInternalformativ(uint32_t target, uint32_t internalformat, uint32_t pname, uint64_t paramsSize, CompletionHandler<void(std::span<const int32_t>)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    if (!WTF::isValidCapacityForVector<GCGLint>(paramsSize))
        paramsSize = 4;
    Vector<GCGLint, 4> params(paramsSize, 0);
    protectedContext()->getInternalformativ(target, internalformat, pname, params);
    completionHandler(spanReinterpretCast<const int32_t>(params.span()));
}

#if ENABLE(WEBXR)
void RemoteGraphicsContextGL::createExternalImage(uint32_t name, WebCore::GraphicsContextGL::ExternalImageSource&& arg0, uint32_t internalFormat, int32_t layer)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(webXRPromptAccepted());
    MESSAGE_CHECK(m_objectNames.isValidKey(name));
    auto result = protectedContext()->createExternalImage(WTF::move(arg0), internalFormat, layer);
    if (result)
        m_objectNames.add(name, result);
}

void RemoteGraphicsContextGL::deleteExternalImage(uint32_t handle)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(webXRPromptAccepted());
    MESSAGE_CHECK(m_objectNames.isValidKey(handle));
    if (!handle) [[unlikely]]
        return;
    handle = m_objectNames.take(handle);
    protectedContext()->deleteExternalImage(handle);
}

void RemoteGraphicsContextGL::bindExternalImage(uint32_t target, uint32_t arg1)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(webXRPromptAccepted());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg1));
    if (arg1)
        arg1 = m_objectNames.get(arg1);
    protectedContext()->bindExternalImage(target, arg1);
}

void RemoteGraphicsContextGL::createExternalSync(uint32_t name, WebCore::GraphicsContextGL::ExternalSyncSource&& arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(webXRPromptAccepted());
    MESSAGE_CHECK(m_objectNames.isValidKey(name));
    auto result = protectedContext()->createExternalSync(WTF::move(arg0));
    if (result)
        m_objectNames.add(name, result);
}

void RemoteGraphicsContextGL::deleteExternalSync(uint32_t arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(webXRPromptAccepted());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (!arg0) [[unlikely]]
        return;
    arg0 = m_objectNames.take(arg0);
    protectedContext()->deleteExternalSync(arg0);
}

void RemoteGraphicsContextGL::enableRequiredWebXRExtensions(CompletionHandler<void(bool)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(webXREnabled());
    bool returnValue = { };
    returnValue = protectedContext()->enableRequiredWebXRExtensions();
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::addFoveation(WebCore::IntSize&& physicalSizeLeft, WebCore::IntSize&& physicalSizeRight, WebCore::IntSize&& screenSize, std::span<const float>&& horizontalSamplesLeft, std::span<const float>&& verticalSamples, std::span<const float>&& horizontalSamplesRight, CompletionHandler<void(bool)>&& completionHandler)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(webXRPromptAccepted());
    bool returnValue = { };
    returnValue = protectedContext()->addFoveation(physicalSizeLeft, physicalSizeRight, screenSize, horizontalSamplesLeft, verticalSamples, horizontalSamplesRight);
    completionHandler(returnValue);
}

void RemoteGraphicsContextGL::enableFoveation(uint32_t arg0)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(webXRPromptAccepted());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg0));
    if (arg0)
        arg0 = m_objectNames.get(arg0);
    protectedContext()->enableFoveation(arg0);
}

void RemoteGraphicsContextGL::disableFoveation()
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(webXRPromptAccepted());
    protectedContext()->disableFoveation();
}

void RemoteGraphicsContextGL::framebufferResolveRenderbuffer(uint32_t target, uint32_t attachment, uint32_t renderbuffertarget, uint32_t arg3)
{
    assertIsCurrent(workQueue());
    MESSAGE_CHECK(webXRPromptAccepted());
    MESSAGE_CHECK(m_objectNames.isValidKey(arg3));
    if (arg3)
        arg3 = m_objectNames.get(arg3);
    protectedContext()->framebufferResolveRenderbuffer(target, attachment, renderbuffertarget, arg3);
}

#endif

}

#undef MESSAGE_CHECK
#endif
