;;; Copyright (C) 2024 Igalia, S.L.
;;;
;;; Licensed under the Apache License, Version 2.0 (the "License");
;;; you may not use this file except in compliance with the License.
;;; You may obtain a copy of the License at
;;;
;;;    http://www.apache.org/licenses/LICENSE-2.0
;;;
;;; Unless required by applicable law or agreed to in writing, software
;;; distributed under the License is distributed on an "AS IS" BASIS,
;;; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
;;; See the License for the specific language governing permissions and
;;; limitations under the License.

(use-modules (srfi srfi-64)
             (test utils))

(test-begin "test-fibers-waiter-queue")

(with-additional-imports
 ((fibers waiter-queue)
  (fibers operations)
  (hoot boxes))
 (test-call "(#f #t 42 100 #f)"
            (lambda ()
              (define (make-op-state) (make-box #f))
              (define wq (make-waiter-queue))
              (waiter-queue-push! wq (make-op-state) 42)
              (define state (make-op-state))
              (waiter-queue-push! wq state 69)
              (waiter-queue-push! wq state -10)
              (waiter-queue-push! wq (make-op-state) 100)
              (let* ((a (op-state-completed? state))
                     (b (op-state-complete! state))
                     (x (waiter-queue-pop! wq))
                     (y (waiter-queue-pop! wq))
                     (z (waiter-queue-pop! wq)))
                (list a b x y z)))))

(test-end* "test-fibers-waiter-queue")
