% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_tabulate.R
\name{.check_for_missing_combos_in_denom}
\alias{.check_for_missing_combos_in_denom}
\title{Check for Missing Levels in \code{denominator}}
\usage{
.check_for_missing_combos_in_denom(data, denominator, by, strata)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{denominator}{(\code{data.frame})\cr
denominator data frame}

\item{by}{(\code{character})\cr
character vector of by column names}

\item{strata}{(\code{character})\cr
character vector of strata column names}
}
\value{
returns invisible if check is successful, throws an error message if not.
}
\description{
When a user passes a data frame in the \code{denominator} argument, this function
checks that the data frame contains all the same levels of the \code{by}
and \code{strata} variables that appear in \code{data}.
}
\examples{
cards:::.check_for_missing_combos_in_denom(ADSL, denominator = "col", by = "ARM", strata = "AGEGR1")
}
\keyword{internal}
