% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract_test}
\alias{extract_test}
\title{Extract a reprex from a failed expectation}
\usage{
extract_test(location, path = stdout(), package = Sys.getenv("TESTTHAT_PKG"))
}
\arguments{
\item{location}{A string giving the location in the form
\verb{FILE:LINE[:COLUMN]}.}

\item{path}{Path to write the reprex to. Defaults to \code{stdout()}.}

\item{package}{If supplied, will be used to construct a test environment
for the extracted code.}
}
\value{
This function is called for its side effect of rendering a
reprex to \code{path}. This function will never error: if extraction
fails, the error message will be written to \code{path}.
}
\description{
\code{extract_test()} creates a minimal reprex for a failed expectation.
It extracts all non-test code before the failed expectation as well as
all code inside the test up to and including the failed expectation.

This is particularly useful when you're debugging test failures in
someone else's package.
}
\examples{
# If you see a test failure like this:
# -- Failure (test-extract.R:46:3): errors if can't find test -------------
# Expected FALSE to be TRUE.
# Differences:
# `actual`:   FALSE
# `expected`: TRUE

# You can run this:
\dontrun{extract_test("test-extract.R:46:3")}
# to see just the code needed to reproduce the failure
}
